/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part;

import it.zerono.mods.extremereactors.api.radiation.RadiationPacket;
import it.zerono.mods.extremereactors.api.reactor.FuelProperties;
import it.zerono.mods.extremereactors.api.reactor.IHeatEntity;
import it.zerono.mods.extremereactors.api.reactor.Moderator;
import it.zerono.mods.extremereactors.api.reactor.radiation.IRadiationModerator;
import it.zerono.mods.extremereactors.api.reactor.radiation.IrradiationData;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.FuelRodsLayout;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IIrradiationSource;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IReactorReader;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.ReactantHelper;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.AbstractReactorEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorControlRodEntity;
import it.zerono.mods.zerocore.base.multiblock.AbstractMultiblockController;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.PartPosition;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;

public class ReactorFuelRodEntity
extends AbstractReactorEntity
implements IRadiationModerator,
IHeatEntity,
IIrradiationSource {
    public static final int FUEL_CAPACITY_PER_FUEL_ROD = 4000;
    private ReactorControlRodEntity _controlRod = null;
    private int _rodIndex = -1;
    private boolean _occluded = false;

    public ReactorFuelRodEntity(BlockPos position, BlockState blockState) {
        super((BlockEntityType)Content.TileEntityTypes.REACTOR_FUELROD.get(), position, blockState);
    }

    public double getHeatTransferRate() {
        Direction.Plane fuelAssemblyPlane = CodeHelper.perpendicularPlane((Direction.Axis)this.getFuelRodsLayout().getAxis());
        Level world = this.getPartWorldOrFail();
        BlockPos rodPosition = this.m_58899_();
        double heatTransferRate = 0.0;
        for (Direction dir : fuelAssemblyPlane) {
            BlockPos targetPosition = rodPosition.m_142300_(dir);
            BlockState state = world.m_8055_(targetPosition);
            if (state.m_60795_()) {
                heatTransferRate += (double)0.05f;
                continue;
            }
            BlockEntity te = WorldHelper.getLoadedTile((Level)world, (BlockPos)targetPosition);
            if (!(te instanceof ReactorFuelRodEntity) && te instanceof IHeatEntity) {
                heatTransferRate += ((IHeatEntity)te).getThermalConductivity();
                continue;
            }
            heatTransferRate += this.getConductivityFromBlock(state);
        }
        return heatTransferRate;
    }

    public void linkToControlRod(ReactorControlRodEntity controlRod, int rodIndex) {
        this._controlRod = controlRod;
        this._rodIndex = rodIndex;
    }

    @Override
    public boolean isLinked() {
        return null != this._controlRod;
    }

    public int getFuelRodIndex() {
        return this._rodIndex;
    }

    public void setOccluded(boolean occluded) {
        this._occluded = occluded;
    }

    public boolean isOccluded() {
        return this._occluded;
    }

    @Override
    protected IModelData getUpdatedModelData() {
        return this.getFuelRodsLayoutForRendering().getFuelRodModelData(this.getFuelRodIndex(), this.isOccluded());
    }

    public FuelRodsLayout getFuelRodsLayout() {
        return (FuelRodsLayout)this.evalOnController(IReactorReader::getFuelRodsLayout, FuelRodsLayout.EMPTY);
    }

    public FuelRodsLayout getFuelRodsLayoutForRendering() {
        return this.isMachineAssembled() && this.testOnController(AbstractMultiblockController::isInteriorVisible) ? this.getFuelRodsLayout() : FuelRodsLayout.EMPTY;
    }

    @Override
    public void moderateRadiation(IrradiationData irradiationData, RadiationPacket radiation) {
        if (!this.isConnected() || !this.isLinked()) {
            return;
        }
        double fuelHeat = (Double)this.evalOnController(c -> c.getFuelHeat().getAsDouble(), 0.0);
        float controlRodInsertion = null != this._controlRod ? this._controlRod.getInsertionPercentage() : 100.0f;
        FuelProperties fuelData = (FuelProperties)this.evalOnController(IReactorReader::getFuelProperties, FuelProperties.INVALID);
        float baseAbsorption = (float)(1.0 - 0.95 * Math.exp(-10.0 * Math.exp(-0.0022 * fuelHeat))) * (1.0f - radiation.hardness / fuelData.getHardnessDivisor());
        float scaledAbsorption = Math.min(1.0f, baseAbsorption * fuelData.getAbsorptionCoefficient());
        float controlRodBonus = (1.0f - scaledAbsorption) * controlRodInsertion * 0.5f;
        float controlRodPenalty = scaledAbsorption * controlRodInsertion * 0.5f;
        float radiationAbsorbed = (scaledAbsorption + controlRodBonus) * radiation.intensity;
        float fertilityAbsorbed = (scaledAbsorption - controlRodPenalty) * radiation.intensity;
        float fuelModerationFactor = fuelData.getModerationFactor();
        fuelModerationFactor += fuelModerationFactor * controlRodInsertion + controlRodInsertion;
        radiation.intensity = Math.max(0.0f, radiation.intensity - radiationAbsorbed);
        radiation.hardness /= fuelModerationFactor;
        irradiationData.fuelEnergyAbsorption += (double)(radiationAbsorbed * 10.0f);
        irradiationData.fuelAbsorbedRadiation += fertilityAbsorbed;
    }

    @Override
    public double getThermalConductivity() {
        return 1.0;
    }

    @Override
    public byte getControlRodInsertionRatio() {
        return null != this._controlRod ? this._controlRod.getInsertionRatio() : (byte)0;
    }

    @Override
    public Direction[] getIrradiationDirections() {
        return this.getFuelRodsLayout().getRadiateDirections();
    }

    @Override
    public boolean isGoodForPosition(PartPosition position, IMultiblockValidator validatorCallback) {
        if (PartPosition.Interior != position) {
            validatorCallback.setLastError(this.getWorldPosition(), "multiblock.validation.reactor.invalid_fuelrod_position", new Object[0]);
            return false;
        }
        return true;
    }

    private double getConductivityFromBlock(BlockState blockState) {
        return ReactantHelper.getModeratorFrom(blockState, Moderator.AIR).getHeatConductivity();
    }
}

