/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.model;

import it.unimi.dsi.fastutil.shorts.Short2ObjectArrayMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.ClientFuelRodsLayout;
import it.zerono.mods.zerocore.lib.client.model.data.AbstractModelDataMap;
import it.zerono.mods.zerocore.lib.client.model.data.NamedModelProperty;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraftforge.client.model.data.ModelProperty;

public class ReactorFuelRodModelData
extends AbstractModelDataMap {
    public static final ReactorFuelRodModelData DEFAULT;
    public static final ModelProperty<Short> REACTANTS_MODEL_KEY;
    public static final ModelProperty<Direction.Axis> ORIENTATION;
    public static final ModelProperty<Boolean> OCCLUDED;
    public static final ModelProperty<Byte> FUEL_LEVEL;
    public static final ModelProperty<Byte> WASTE_LEVEL;
    private static final Short2ObjectMap<ReactorFuelRodModelData> s_cache;

    public static ReactorFuelRodModelData from(ClientFuelRodsLayout.FuelData fuelData, boolean rodIsOccluded) {
        return ReactorFuelRodModelData.from(fuelData.getOrientation(), fuelData.getFuelLevel(), fuelData.getWasteLevel(), rodIsOccluded);
    }

    public short getModelKey() {
        Short v = (Short)this.getData(REACTANTS_MODEL_KEY);
        return null != v ? v : (short)0;
    }

    public Direction.Axis getOrientation() {
        Direction.Axis v = (Direction.Axis)this.getData(ORIENTATION);
        return null == v ? Direction.Axis.X : v;
    }

    public boolean isOccluded() {
        Boolean v = (Boolean)this.getData(OCCLUDED);
        return null != v && v != false;
    }

    public byte getFuelLevel() {
        Byte v = (Byte)this.getData(FUEL_LEVEL);
        return null != v ? v : (byte)0;
    }

    public byte getWasteLevel() {
        Byte v = (Byte)this.getData(WASTE_LEVEL);
        return null != v ? v : (byte)0;
    }

    private ReactorFuelRodModelData(int dataKey, Direction.Axis axis, byte fuelLevel, byte wasteLevel, boolean rodIsOccluded) {
        super(5);
        this.addProperty(REACTANTS_MODEL_KEY, (short)(dataKey & 0xFF));
        this.addProperty(ORIENTATION, axis);
        this.addProperty(OCCLUDED, rodIsOccluded);
        this.addProperty(FUEL_LEVEL, fuelLevel);
        this.addProperty(WASTE_LEVEL, wasteLevel);
    }

    private static short createKey(Direction.Axis axis, byte fuelLevel, byte wasteLevel, boolean rodIsOccluded) {
        return (short)((switch (axis) {
            case Direction.Axis.X -> 16384;
            case Direction.Axis.Z -> 49152;
            default -> 0;
        }) | (rodIsOccluded ? 8192 : 0) | fuelLevel << 4 | wasteLevel & 0xF);
    }

    private static ReactorFuelRodModelData from(Direction.Axis axis, byte fuelLevel, byte wasteLevel, boolean rodIsOccluded) {
        return (ReactorFuelRodModelData)((Object)s_cache.computeIfAbsent(ReactorFuelRodModelData.createKey(axis, fuelLevel, wasteLevel, rodIsOccluded), k -> new ReactorFuelRodModelData(k, axis, fuelLevel, wasteLevel, rodIsOccluded)));
    }

    static {
        REACTANTS_MODEL_KEY = new NamedModelProperty("REACTANTS_MODEL_KEY", Objects::nonNull);
        ORIENTATION = new NamedModelProperty("ORIENTATION", Objects::nonNull);
        OCCLUDED = new NamedModelProperty("OCCLUDED", Objects::nonNull);
        FUEL_LEVEL = new NamedModelProperty("FUEL_LEVEL", Objects::nonNull);
        WASTE_LEVEL = new NamedModelProperty("WASTE_LEVEL", Objects::nonNull);
        s_cache = new Short2ObjectArrayMap(512);
        DEFAULT = ReactorFuelRodModelData.from(Direction.Axis.Y, (byte)0, (byte)0, false);
    }
}

