/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import it.zerono.mods.extremereactors.api.IMapping;
import it.zerono.mods.extremereactors.api.reactor.Moderator;
import it.zerono.mods.extremereactors.api.reactor.ModeratorsRegistry;
import it.zerono.mods.extremereactors.api.reactor.Reactant;
import it.zerono.mods.extremereactors.api.reactor.ReactantMappingsRegistry;
import it.zerono.mods.extremereactors.api.reactor.ReactantType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.FuelContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IFuelSource;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.ReactantStack;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.variant.IMultiblockReactorVariant;
import it.zerono.mods.zerocore.lib.data.stack.OperationMode;
import it.zerono.mods.zerocore.lib.fluid.FluidHelper;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;

public class ReactantHelper {
    private static final Cache<BlockState, Moderator> s_moderatorsCache = CacheBuilder.newBuilder().initialCapacity(4).concurrencyLevel(2).maximumSize(128L).expireAfterAccess(5L, TimeUnit.MINUTES).build();

    public static boolean isValidSource(ReactantType type, ItemStack stack) {
        return !stack.m_41619_() && ReactantMappingsRegistry.getFromSolid(stack).map(IMapping::getProduct).map(reactant -> reactant.test(type)).orElse(false) != false;
    }

    public static boolean isValidSource(ReactantType type, FluidStack stack) {
        return !stack.isEmpty() && ReactantMappingsRegistry.getFromFluid(stack).map(IMapping::getProduct).map(reactant -> reactant.test(type)).orElse(false) != false;
    }

    static <T> boolean ejectReactant(ReactantType type, boolean fluid, FuelContainer container, boolean voidLeftover, Stream<IFuelSource<T>> fuelSources) {
        boolean ejected = container.getContent(type).map(reactant -> ReactantHelper.ejectReactant(reactant, fluid, container, fuelSources)).orElse(false);
        if (ejected && voidLeftover) {
            container.clear(type);
        }
        return ejected;
    }

    private static <T> boolean ejectReactant(Reactant reactant, boolean fluid, FuelContainer container, Stream<IFuelSource<T>> fuelSources) {
        int minimumReactantAmount = fluid ? reactant.getMinimumFluidSourceAmount() : reactant.getMinimumSolidSourceAmount();
        return minimumReactantAmount > 0 && container.getContentAmount(reactant.getType()) >= minimumReactantAmount && ReactantHelper.ejectReactant(reactant, minimumReactantAmount, container, fuelSources) > 0;
    }

    private static <T> int ejectReactant(Reactant reactant, int minimumReactantAmount, FuelContainer container, Stream<IFuelSource<T>> fuelSources) {
        return fuelSources.mapToInt(port -> ReactantHelper.ejectReactant(reactant, minimumReactantAmount, container, port)).sum();
    }

    private static <T> int ejectReactant(Reactant reactant, int minimumReactantAmount, FuelContainer container, IFuelSource<T> fuelSource) {
        if (container.getContentAmount(reactant.getType()) >= minimumReactantAmount) {
            int reactantEjected = fuelSource.emitReactant(reactant, container.getContentAmount(reactant.getType()));
            return container.voidReactant(reactant.getType(), reactantEjected);
        }
        return 0;
    }

    static boolean refuelSolid(FuelContainer container, Stream<IFuelSource<ItemStack>> sources, IMultiblockReactorVariant variant) {
        return sources.filter(source -> container.getFreeSpace(ReactantType.Fuel) >= 1000).mapToInt(source -> ReactantHelper.refuelSolid(container, source, variant)).sum() > 0;
    }

    private static int refuelSolid(FuelContainer container, IFuelSource<ItemStack> fuelSource, IMultiblockReactorVariant variant) {
        ItemStack fuelSourceStack = fuelSource.getFuelStack();
        return ReactantMappingsRegistry.getFromSolid(fuelSourceStack).filter(mapping -> ((Reactant)mapping.getProduct()).getType().isFuel()).map(mapping -> ReactantHelper.refuelSolid(container, fuelSource, variant, fuelSourceStack, mapping)).orElse(0);
    }

    private static int refuelSolid(FuelContainer container, IFuelSource<ItemStack> fuelSource, IMultiblockReactorVariant variant, ItemStack fuelSourceStack, IMapping<TagKey<Item>, Reactant> fuelMapping) {
        ItemStack fuelConsumedStack;
        ReactantStack availableFuel = new ReactantStack(fuelMapping, fuelSourceStack.m_41613_());
        if (availableFuel.isEmpty() || !availableFuel.getReactant().isPresent()) {
            return 0;
        }
        int storableReactantAmount = container.insertFuel(availableFuel, OperationMode.Simulate);
        if (storableReactantAmount <= 0) {
            return 0;
        }
        ItemStack maxSourceToConsume = ItemHelper.stackFrom((ItemStack)fuelSourceStack, (int)fuelMapping.getSourceAmount(storableReactantAmount));
        if (!maxSourceToConsume.m_41619_() && !(fuelConsumedStack = fuelSource.consumeFuelSource(maxSourceToConsume)).m_41619_() && fuelConsumedStack.m_41613_() > 0) {
            float conversionEfficiency = Mth.m_14036_((float)variant.getSolidFuelConversionEfficiency(), (float)0.0f, (float)1.0f);
            int amountToAdd = fuelMapping.getProductAmount(fuelConsumedStack.m_41613_());
            if (conversionEfficiency < 1.0f) {
                amountToAdd = Mth.m_14143_((float)((float)amountToAdd * conversionEfficiency));
            }
            amountToAdd = Math.min(storableReactantAmount, amountToAdd);
            return container.insertFuel(availableFuel.getReactant().get(), amountToAdd, OperationMode.Execute);
        }
        return 0;
    }

    static boolean refuelFluid(FuelContainer container, Stream<IFuelSource<FluidStack>> sources, IMultiblockReactorVariant variant) {
        return sources.filter(source -> container.getFreeSpace(ReactantType.Fuel) >= 1000).mapToInt(source -> ReactantHelper.refuelFluid(container, source, variant)).sum() > 0;
    }

    private static int refuelFluid(FuelContainer container, IFuelSource<FluidStack> fuelSource, IMultiblockReactorVariant variant) {
        FluidStack fuelSourceStack = fuelSource.getFuelStack();
        return ReactantMappingsRegistry.getFromFluid(fuelSourceStack).filter(mapping -> ((Reactant)mapping.getProduct()).getType().isFuel()).map(mapping -> ReactantHelper.refuelFluid(container, fuelSource, variant, fuelSourceStack, mapping)).orElse(0);
    }

    private static int refuelFluid(FuelContainer container, IFuelSource<FluidStack> fuelSource, IMultiblockReactorVariant variant, FluidStack fuelSourceStack, IMapping<TagKey<Fluid>, Reactant> fuelMapping) {
        FluidStack fuelConsumedStack;
        int availableReactantAmount = fuelSourceStack.getAmount();
        if (availableReactantAmount <= 0) {
            return 0;
        }
        Reactant reactant = fuelMapping.getProduct();
        int storableReactantAmount = container.insertFuel(new ReactantStack(reactant, availableReactantAmount), OperationMode.Simulate);
        if (storableReactantAmount <= 0) {
            return 0;
        }
        FluidStack maxSourceToConsume = FluidHelper.stackFrom((FluidStack)fuelSourceStack, (int)storableReactantAmount);
        if (!maxSourceToConsume.isEmpty() && !(fuelConsumedStack = fuelSource.consumeFuelSource(maxSourceToConsume)).isEmpty() && fuelConsumedStack.getAmount() > 0) {
            return container.insertFuel(reactant, Math.min(storableReactantAmount, fuelConsumedStack.getAmount()), OperationMode.Execute);
        }
        return 0;
    }

    @Nullable
    public static Moderator getModeratorFrom(BlockState state) {
        return ReactantHelper.getCachedModeratorFrom(state);
    }

    public static Moderator getModeratorFrom(BlockState state, Moderator fallbackModerator) {
        Moderator moderator = ReactantHelper.getCachedModeratorFrom(state);
        return null != moderator ? moderator : fallbackModerator;
    }

    public static boolean isValidModerator(BlockState state) {
        return null != ReactantHelper.getCachedModeratorFrom(state);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onVanillaTagsUpdated(TagsUpdatedEvent event) {
        s_moderatorsCache.invalidateAll();
    }

    @Nullable
    private static Moderator getCachedModeratorFrom(BlockState state) {
        Optional<Moderator> m;
        Moderator moderator = (Moderator)s_moderatorsCache.getIfPresent((Object)state);
        if (null == moderator && (m = ModeratorsRegistry.getFrom(state)).isPresent()) {
            moderator = m.get();
            s_moderatorsCache.put((Object)state, (Object)moderator);
        }
        return moderator;
    }
}

