/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.util.recipes;

import cofh.lib.fluid.FluidIngredient;
import cofh.lib.util.recipes.SerializableRecipe;
import cofh.thermal.core.ThermalCore;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;

public abstract class ThermalRecipe
extends SerializableRecipe {
    protected final List<Ingredient> inputItems = new ArrayList<Ingredient>();
    protected final List<FluidIngredient> inputFluids = new ArrayList<FluidIngredient>();
    protected final List<ItemStack> outputItems = new ArrayList<ItemStack>();
    protected final List<FluidStack> outputFluids = new ArrayList<FluidStack>();
    protected final List<Float> outputItemChances = new ArrayList<Float>();
    protected int energy;
    protected float xp;
    protected boolean catalyzable;

    protected ThermalRecipe(ResourceLocation recipeId, int energy, float xp, List<Ingredient> inputItems, List<FluidIngredient> inputFluids, List<ItemStack> outputItems, List<Float> outputItemChances, List<FluidStack> outputFluids) {
        super(recipeId);
        if ((inputItems == null || inputItems.isEmpty()) && (inputFluids == null || inputFluids.isEmpty()) || (outputItems == null || outputItems.isEmpty()) && (outputFluids == null || outputFluids.isEmpty())) {
            ThermalCore.LOG.warn("Invalid Thermal Series recipe: " + recipeId + "\nRefer to the recipe's ResourceLocation to find the mod responsible and let them know!");
        }
        this.energy = energy;
        this.xp = Math.max(0.0f, xp);
        if (inputItems != null) {
            this.inputItems.addAll(inputItems);
        }
        if (inputFluids != null) {
            this.inputFluids.addAll(inputFluids);
        }
        if (outputItems != null) {
            this.outputItems.addAll(outputItems);
            if (outputItemChances != null) {
                this.outputItemChances.addAll(outputItemChances);
            }
            if (this.outputItemChances.size() < this.outputItems.size()) {
                for (int i = this.outputItemChances.size(); i < this.outputItems.size(); ++i) {
                    this.outputItemChances.add(Float.valueOf(-1.0f));
                }
            }
            for (float f : this.outputItemChances) {
                this.catalyzable |= f >= 0.0f;
            }
        }
        if (outputFluids != null) {
            this.outputFluids.addAll(outputFluids);
        }
        this.trim();
    }

    private void trim() {
        ((ArrayList)this.inputItems).trimToSize();
        ((ArrayList)this.inputFluids).trimToSize();
        ((ArrayList)this.outputItems).trimToSize();
        ((ArrayList)this.outputFluids).trimToSize();
        ((ArrayList)this.outputItemChances).trimToSize();
    }

    public List<Ingredient> getInputItems() {
        return this.inputItems;
    }

    public List<FluidIngredient> getInputFluids() {
        return this.inputFluids;
    }

    public List<ItemStack> getOutputItems() {
        return this.outputItems;
    }

    public List<FluidStack> getOutputFluids() {
        return this.outputFluids;
    }

    public List<Float> getOutputItemChances() {
        return this.outputItemChances;
    }

    public int getEnergy() {
        return this.energy;
    }

    public float getXp() {
        return this.xp;
    }

    public boolean isCatalyzable() {
        return this.catalyzable;
    }
}

