/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.compat.crt;

import com.blamejared.crafttweaker.api.bracket.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.fluid.MCFluidStackMutable;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.MCItemStack;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;

public class RecipePrintingUtil {
    public static String stringifyIngredients(List<Ingredient> ingredients, String delimeter) {
        return ingredients.stream().map(IIngredient::fromIngredient).map(CommandStringDisplayable::getCommandString).collect(Collectors.joining(delimeter));
    }

    public static String stringifyStacks(List<ItemStack> ingredients, String delimeter) {
        return ingredients.stream().map(MCItemStack::new).map(CommandStringDisplayable::getCommandString).collect(Collectors.joining(delimeter));
    }

    public static String stringifyWeightedStacks(List<ItemStack> ingredients, List<Float> weights, String delimeter) {
        Iterator<Float> iterator = weights.iterator();
        return ingredients.stream().filter(val -> iterator.hasNext()).map(itemStack -> new MCItemStack(itemStack).percent((double)(((Float)iterator.next()).floatValue() * 100.0f))).map(CommandStringDisplayable::getCommandString).collect(Collectors.joining(delimeter));
    }

    public static String stringifyFluidStacks(List<FluidStack> ingredients, String delimeter) {
        return ingredients.stream().map(MCFluidStackMutable::new).map(CommandStringDisplayable::getCommandString).collect(Collectors.joining(delimeter));
    }
}

