/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.client.renderer.entity.model;

import java.util.Arrays;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class BlitzModel<T extends LivingEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation BLITZ_LAYER = new ModelLayerLocation(new ResourceLocation("thermal:blitz"), "main");
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart[] body;
    private final ModelPart cyclone;

    public BlitzModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("head");
        this.body = new ModelPart[3];
        this.cyclone = root.m_171324_("cyclone");
        Arrays.setAll(this.body, num -> root.m_171324_("body_" + num));
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 39).m_171481_(-6.0f, -7.0f, -4.0f, 12.0f, 8.0f, 8.0f), PartPose.f_171404_);
        partdefinition.m_171599_("body_0", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-8.0f, 2.0f, -8.0f, 16.0f, 6.0f, 16.0f), PartPose.f_171404_);
        partdefinition.m_171599_("body_1", CubeListBuilder.m_171558_().m_171514_(0, 23).m_171481_(-5.0f, 9.0f, -5.0f, 10.0f, 6.0f, 10.0f), PartPose.f_171404_);
        partdefinition.m_171599_("body_2", CubeListBuilder.m_171558_().m_171514_(40, 27).m_171481_(-3.0f, 16.0f, -3.0f, 6.0f, 6.0f, 6.0f), PartPose.f_171404_);
        partdefinition.m_171599_("cyclone", CubeListBuilder.m_171558_().m_171514_(15, 39).m_171481_(-12.5f, 23.0f, -12.5f, 25.0f, 0.0f, 25.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTicks = ageInTicks - (float)((LivingEntity)entityIn).f_19797_;
        for (int i = 0; i < this.body.length; ++i) {
            this.body[i].f_104204_ = (ageInTicks * (float)(i + 1) * 10.0f - Mth.m_14179_((float)partialTicks, (float)((LivingEntity)entityIn).f_20884_, (float)((LivingEntity)entityIn).f_20883_)) * (float)Math.PI / 180.0f;
        }
        this.cyclone.f_104204_ = (ageInTicks * 20.0f - Mth.m_14179_((float)partialTicks, (float)((LivingEntity)entityIn).f_20884_, (float)((LivingEntity)entityIn).f_20883_)) * (float)Math.PI / 180.0f;
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
    }
}

