/*
 * Decompiled with CFR 0.152.
 */
package com.robocraft999.creategoggles.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.robocraft999.creategoggles.CGConfig;
import com.robocraft999.creategoggles.item.modifier.ItemModifier;
import com.robocraft999.creategoggles.item.modifier.ItemModifierManager;
import com.robocraft999.creategoggles.registry.CGItemModifiers;
import com.robocraft999.creategoggles.registry.CGRecipeTypes;
import dev.architectury.core.AbstractRecipeSerializer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.UpgradeRecipe;
import net.minecraft.world.level.Level;

public class ApplyModifierRecipe
extends UpgradeRecipe {
    private final ItemModifier modifier;
    private final Ingredient addition;

    public ApplyModifierRecipe(ResourceLocation id, Ingredient addition, ItemModifier modifier) {
        super(id, Ingredient.f_43901_, addition, ItemStack.f_41583_);
        this.addition = addition;
        this.modifier = modifier;
    }

    public boolean m_5818_(Container inv, Level level) {
        if (!this.modifier.isItemValid(inv.m_8020_(0))) {
            return false;
        }
        if (!((Boolean)CGConfig.COMMON.enableExperimentalFeatures.get()).booleanValue()) {
            return false;
        }
        return this.addition.test(inv.m_8020_(1));
    }

    public ItemStack m_5874_(Container inv) {
        ItemStack stack = inv.m_8020_(0).m_41777_();
        ItemModifierManager.setModifier(stack, this.modifier);
        return stack;
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CGRecipeTypes.APPLY_MODFIER.get();
    }

    public ItemModifier getModifier() {
        return this.modifier;
    }

    public Ingredient getAddition() {
        return this.addition;
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    extends AbstractRecipeSerializer<ApplyModifierRecipe> {
        public ApplyModifierRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient addition = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"addition"));
            ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)json, (String)"modifier"));
            String name = resourceLocation.m_135815_();
            if (!CGItemModifiers.ITEM_MODIFIERS.contains(resourceLocation)) {
                throw new JsonSyntaxException("Unknown item modifier '" + resourceLocation + "'");
            }
            ItemModifier modifier = (ItemModifier)CGItemModifiers.ITEM_MODIFIERS.get(resourceLocation);
            return new ApplyModifierRecipe(recipeId, addition, modifier);
        }

        public ApplyModifierRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient addition = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemModifier modifier = (ItemModifier)CGItemModifiers.ITEM_MODIFIERS.get(buffer.m_130281_());
            return new ApplyModifierRecipe(recipeId, addition, modifier);
        }

        public void toNetwork(FriendlyByteBuf buffer, ApplyModifierRecipe recipe) {
            recipe.addition.m_43923_(buffer);
            buffer.m_130085_(recipe.getModifier().getRegistryName());
        }
    }
}

