/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.particle;

import codechicken.lib.internal.network.CCLNetwork;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.raytracer.VoxelShapeBlockHitResult;
import codechicken.lib.render.particle.CustomBreakingParticle;
import codechicken.lib.render.particle.IModelParticleProvider;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;

public class CustomParticleHandler {
    public static boolean handleLandingEffects(ServerLevel world, BlockPos pos, LivingEntity entity, int numParticles) {
        PacketCustom packet = new PacketCustom(CCLNetwork.NET_CHANNEL, 1);
        packet.writePos(pos);
        packet.writeVector(Vector3.fromEntity((Entity)entity));
        packet.writeVarInt(numParticles);
        packet.sendToPlayer((ServerPlayer)entity);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean handleRunningEffects(Level world, BlockPos pos, BlockState state, Entity entity) {
        BlockHitResult traceResult = new BlockHitResult(entity.m_20182_().m_82520_(0.0, 1.0, 0.0), Direction.UP, pos, false);
        BlockModelShaper modelShapes = Minecraft.m_91087_().m_91289_().m_110907_();
        BakedModel model = modelShapes.m_110893_(state);
        if (model instanceof IModelParticleProvider) {
            IModelData modelData = ModelDataManager.getModelData((Level)world, (BlockPos)pos);
            ParticleEngine particleManager = Minecraft.m_91087_().f_91061_;
            ArrayList<TextureAtlasSprite> sprites = new ArrayList<TextureAtlasSprite>(((IModelParticleProvider)model).getHitEffects(traceResult, state, (BlockAndTintGetter)world, pos, modelData));
            TextureAtlasSprite rolledSprite = (TextureAtlasSprite)sprites.get(world.f_46441_.nextInt(sprites.size()));
            double x = entity.m_20185_() + ((double)world.f_46441_.nextFloat() - 0.5) * (double)entity.m_20205_();
            double y = entity.m_142469_().f_82289_ + 0.1;
            double z = entity.m_20189_() + ((double)world.f_46441_.nextFloat() - 0.5) * (double)entity.m_20205_();
            particleManager.m_107344_((Particle)new CustomBreakingParticle((ClientLevel)world, x, y, z, -entity.m_20184_().f_82479_ * 4.0, 1.5, -entity.m_20184_().f_82481_ * 4.0, rolledSprite));
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean handleHitEffects(BlockState state, Level world, HitResult traceResult, ParticleEngine manager) {
        if (traceResult instanceof BlockHitResult) {
            BlockHitResult hit = (BlockHitResult)traceResult;
            BlockPos pos = hit.m_82425_();
            BlockModelShaper modelShapes = Minecraft.m_91087_().m_91289_().m_110907_();
            BakedModel model = modelShapes.m_110893_(state);
            if (model instanceof IModelParticleProvider) {
                IModelData modelData = ModelDataManager.getModelData((Level)world, (BlockPos)pos);
                Cuboid6 bounds = new Cuboid6();
                if (hit instanceof VoxelShapeBlockHitResult) {
                    bounds.set(((VoxelShapeBlockHitResult)hit).shape.m_83215_());
                } else {
                    bounds.set(state.m_60808_((BlockGetter)world, pos).m_83215_());
                }
                bounds = bounds.copy().add(pos);
                Set<TextureAtlasSprite> hitSprites = ((IModelParticleProvider)model).getHitEffects(hit, state, (BlockAndTintGetter)world, pos, modelData);
                ArrayList<TextureAtlasSprite> sprites = new ArrayList<TextureAtlasSprite>(hitSprites);
                CustomParticleHandler.addBlockHitEffects(world, bounds, hit.m_82434_(), (TextureAtlasSprite)sprites.get(world.f_46441_.nextInt(sprites.size())), manager);
                return true;
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean handleDestroyEffects(Level world, BlockPos pos, BlockState state, ParticleEngine manager) {
        BlockModelShaper modelShapes = Minecraft.m_91087_().m_91289_().m_110907_();
        BakedModel model = modelShapes.m_110893_(state);
        if (model instanceof IModelParticleProvider) {
            IModelData modelData = ModelDataManager.getModelData((Level)world, (BlockPos)pos);
            Cuboid6 bounds = new Cuboid6(state.m_60808_((BlockGetter)world, pos).m_83215_());
            CustomParticleHandler.addBlockDestroyEffects(world, bounds.add(pos), new ArrayList<TextureAtlasSprite>(((IModelParticleProvider)model).getDestroyEffects(state, (BlockAndTintGetter)world, pos, modelData)), manager);
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addLandingEffects(Level world, BlockPos pos, BlockState state, Vector3 entityPos, int numParticles) {
        BlockHitResult traceResult = new BlockHitResult(new Vec3(entityPos.x, (double)(pos.m_123342_() + 1), entityPos.z), Direction.UP, pos, false);
        ParticleEngine manager = Minecraft.m_91087_().f_91061_;
        Random randy = new Random();
        BlockModelShaper modelShapes = Minecraft.m_91087_().m_91289_().m_110907_();
        BakedModel model = modelShapes.m_110893_(state);
        if (model instanceof IModelParticleProvider) {
            IModelData modelData = ModelDataManager.getModelData((Level)world, (BlockPos)pos);
            ArrayList<TextureAtlasSprite> sprites = new ArrayList<TextureAtlasSprite>(((IModelParticleProvider)model).getHitEffects(traceResult, state, (BlockAndTintGetter)world, pos, modelData));
            double speed = 0.15f;
            if (numParticles != 0) {
                for (int i = 0; i < numParticles; ++i) {
                    double mX = randy.nextGaussian() * speed;
                    double mY = randy.nextGaussian() * speed;
                    double mZ = randy.nextGaussian() * speed;
                    manager.m_107344_((Particle)CustomBreakingParticle.newLandingParticle((ClientLevel)world, entityPos.x, entityPos.y, entityPos.z, mX, mY, mZ, (TextureAtlasSprite)sprites.get(randy.nextInt(sprites.size()))));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addBlockHitEffects(Level world, Cuboid6 bounds, Direction side, TextureAtlasSprite icon, ParticleEngine particleManager) {
        float border = 0.1f;
        Vector3 diff = bounds.max.copy().subtract(bounds.min).add(-2.0f * border);
        diff.x *= world.f_46441_.nextDouble();
        diff.y *= world.f_46441_.nextDouble();
        diff.z *= world.f_46441_.nextDouble();
        Vector3 pos = diff.add(bounds.min).add(border);
        if (side == Direction.DOWN) {
            diff.y = bounds.min.y - (double)border;
        }
        if (side == Direction.UP) {
            diff.y = bounds.max.y + (double)border;
        }
        if (side == Direction.NORTH) {
            diff.z = bounds.min.z - (double)border;
        }
        if (side == Direction.SOUTH) {
            diff.z = bounds.max.z + (double)border;
        }
        if (side == Direction.WEST) {
            diff.x = bounds.min.x - (double)border;
        }
        if (side == Direction.EAST) {
            diff.x = bounds.max.x + (double)border;
        }
        particleManager.m_107344_(new CustomBreakingParticle((ClientLevel)world, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0, icon).m_107268_(0.2f).m_6569_(0.6f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addBlockDestroyEffects(Level world, Cuboid6 bounds, List<TextureAtlasSprite> icons, ParticleEngine particleManager) {
        Vector3 diff = bounds.max.copy().subtract(bounds.min);
        Vector3 center = bounds.min.copy().add(bounds.max).multiply(0.5);
        Vector3 density = diff.copy().multiply(4.0).ceil();
        int i = 0;
        while ((double)i < density.x) {
            int j = 0;
            while ((double)j < density.y) {
                int k = 0;
                while ((double)k < density.z) {
                    double x = bounds.min.x + ((double)i + 0.5) * diff.x / density.x;
                    double y = bounds.min.y + ((double)j + 0.5) * diff.y / density.y;
                    double z = bounds.min.z + ((double)k + 0.5) * diff.z / density.z;
                    particleManager.m_107344_((Particle)new CustomBreakingParticle((ClientLevel)world, x, y, z, x - center.x, y - center.y, z - center.z, icons.get(world.f_46441_.nextInt(icons.size()))));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }
}

