/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.block;

import codechicken.lib.internal.ExceptionMessageEventHandler;
import codechicken.lib.internal.proxy.ProxyClient;
import codechicken.lib.render.block.BlockRenderingRegistry;
import codechicken.lib.render.block.ICCBlockRenderer;
import codechicken.lib.util.LambdaUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CCBlockRendererDispatcher
extends BlockRenderDispatcher {
    private static final Logger logger = LogManager.getLogger();
    public final BlockRenderDispatcher parentDispatcher;
    private static long lastTime;

    public CCBlockRendererDispatcher(BlockRenderDispatcher parent, BlockColors blockColours) {
        super(parent.m_110907_(), parent.f_173397_, blockColours);
        this.parentDispatcher = parent;
        this.f_110900_ = parent.f_110900_;
        this.f_110901_ = parent.f_110901_;
    }

    public boolean renderBatched(BlockState state, BlockPos pos, BlockAndTintGetter level, PoseStack stack, VertexConsumer builder, boolean checkSides, Random rand, IModelData modelData) {
        try {
            ICCBlockRenderer renderer = BlockRenderingRegistry.findFor(state.m_60734_(), e -> e.canHandleBlock(level, pos, state));
            if (renderer != null) {
                return renderer.renderBlock(state, pos, level, stack, builder, rand, modelData);
            }
        }
        catch (Throwable t) {
            if (ProxyClient.catchBlockRenderExceptions) {
                CCBlockRendererDispatcher.handleCaughtException(t, state, pos, level);
                return false;
            }
            CrashReport crashreport = CrashReport.m_127521_((Throwable)t, (String)"Tessellating CCL block in world");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Block being tessellated");
            CrashReportCategory.m_178950_((CrashReportCategory)crashreportcategory, (LevelHeightAccessor)level, (BlockPos)pos, (BlockState)state);
            throw new ReportedException(crashreport);
        }
        try {
            return this.parentDispatcher.renderBatched(state, pos, level, stack, builder, checkSides, rand, modelData);
        }
        catch (Throwable t) {
            if (ProxyClient.catchBlockRenderExceptions) {
                CCBlockRendererDispatcher.handleCaughtException(t, state, pos, level);
                return false;
            }
            throw t;
        }
    }

    public void renderBreakingTexture(BlockState state, BlockPos pos, BlockAndTintGetter world, PoseStack matrixStackIn, VertexConsumer vertexBuilderIn, IModelData data) {
        ICCBlockRenderer renderer = BlockRenderingRegistry.findFor(state.m_60734_(), e -> e.canHandleBlock(world, pos, state));
        if (renderer != null) {
            renderer.renderBreaking(state, pos, world, matrixStackIn, vertexBuilderIn, data);
        } else {
            this.parentDispatcher.renderBreakingTexture(state, pos, world, matrixStackIn, vertexBuilderIn, data);
        }
    }

    public boolean m_203143_(BlockPos pos, BlockAndTintGetter world, VertexConsumer builder, BlockState blockState, FluidState fluidState) {
        ICCBlockRenderer renderer = BlockRenderingRegistry.findFor(fluidState.m_76152_(), e -> e.canHandleFluid(world, pos, blockState, fluidState));
        if (renderer != null) {
            return renderer.renderFluid(pos, world, builder, blockState, fluidState);
        }
        return this.parentDispatcher.m_203143_(pos, world, builder, blockState, fluidState);
    }

    public void renderSingleBlock(BlockState blockStateIn, PoseStack matrixStackIn, MultiBufferSource bufferTypeIn, int combinedLightIn, int combinedOverlayIn, IModelData modelData) {
        ICCBlockRenderer renderer = BlockRenderingRegistry.findFor(blockStateIn.m_60734_(), e -> e.canHandleEntity(blockStateIn));
        if (renderer != null) {
            renderer.renderEntity(blockStateIn, matrixStackIn, bufferTypeIn, combinedLightIn, combinedOverlayIn, modelData);
        } else {
            this.parentDispatcher.renderSingleBlock(blockStateIn, matrixStackIn, bufferTypeIn, combinedLightIn, combinedOverlayIn, modelData);
        }
    }

    private static void handleCaughtException(Throwable t, BlockState inState, BlockPos pos, BlockAndTintGetter world) {
        long time;
        Block inBlock = inState.m_60734_();
        BlockEntity tile = world.m_7702_(pos);
        StringBuilder builder = new StringBuilder("\n CCL has caught an exception whilst rendering a block\n");
        builder.append("  BlockPos:      ").append(String.format("x:%s, y:%s, z:%s", pos.m_123341_(), pos.m_123342_(), pos.m_123343_())).append("\n");
        builder.append("  Block Class:   ").append(LambdaUtils.tryOrNull(() -> inBlock.getClass())).append("\n");
        builder.append("  Registry Name: ").append(LambdaUtils.tryOrNull(() -> inBlock.getRegistryName())).append("\n");
        builder.append("  State:         ").append(inState).append("\n");
        builder.append(" Tile at position\n");
        builder.append("  Tile Class:    ").append(LambdaUtils.tryOrNull(() -> tile.getClass())).append("\n");
        builder.append("  Tile Id:       ").append(LambdaUtils.tryOrNull(() -> BlockEntityType.m_58954_((BlockEntityType)tile.m_58903_()))).append("\n");
        builder.append("  Tile NBT:      ").append(LambdaUtils.tryOrNull(() -> tile.m_187480_())).append("\n");
        builder.append("This functionality can be disabled in the CCL config file.\n");
        if (ProxyClient.messagePlayerOnRenderExceptionCaught) {
            builder.append("You can also turn off player messages in the CCL config file.\n");
        }
        String logMessage = builder.toString();
        String key = ExceptionUtils.getStackTrace((Throwable)t) + logMessage;
        if (ExceptionMessageEventHandler.exceptionMessageCache.add(key)) {
            logger.error(logMessage, t);
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (ProxyClient.messagePlayerOnRenderExceptionCaught && player != null && TimeUnit.NANOSECONDS.toSeconds((time = System.nanoTime()) - lastTime) > 5L) {
            lastTime = time;
            player.m_6352_((Component)new TextComponent("CCL Caught an exception rendering a block. See the log for info."), Util.f_137441_);
        }
    }
}

