/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.ModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class ItemModelProvider
extends ModelProvider<ItemModelBuilder> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final ModelFile.UncheckedModelFile GENERATED = new ModelFile.UncheckedModelFile("item/generated");
    protected static final ModelFile.UncheckedModelFile HANDHELD = new ModelFile.UncheckedModelFile("item/handheld");

    public ItemModelProvider(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper) {
        super(generator, modid, "item", WrappedItemModelBuilder::new, existingFileHelper);
    }

    protected String name(ItemLike item) {
        return item.m_5456_().getRegistryName().m_135815_();
    }

    protected ResourceLocation itemTexture(ItemLike item) {
        return this.itemTexture(item, "");
    }

    protected ResourceLocation itemTexture(Supplier<? extends Item> item) {
        return this.itemTexture(item, "");
    }

    protected ResourceLocation itemTexture(ItemLike item, String folder) {
        String f = "";
        if (!StringUtils.isEmpty((CharSequence)folder)) {
            f = StringUtils.appendIfMissing((String)folder, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        }
        return this.modLoc("item/" + f + this.name(item));
    }

    protected ResourceLocation itemTexture(Supplier<? extends Item> item, String folder) {
        return this.itemTexture((ItemLike)item.get(), folder);
    }

    protected ResourceLocation blockTexture(Block block) {
        return this.itemTexture((ItemLike)block, "");
    }

    protected ResourceLocation blockTexture(Supplier<? extends Block> block) {
        return this.blockTexture(block, "");
    }

    protected ResourceLocation blockTexture(Block block, String folder) {
        String f = "";
        if (!StringUtils.isEmpty((CharSequence)folder)) {
            f = StringUtils.appendIfMissing((String)folder, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        }
        return this.modLoc("block/" + f + this.name((ItemLike)block));
    }

    protected ResourceLocation blockTexture(Supplier<? extends Block> block, String folder) {
        return this.blockTexture(block.get(), folder);
    }

    protected ItemModelBuilder getBuilder(ItemLike item) {
        return (ItemModelBuilder)this.getBuilder(this.name(item));
    }

    protected ItemModelBuilder getBuilder(Supplier<? extends Item> item) {
        return (ItemModelBuilder)this.getBuilder(this.name((ItemLike)item.get()));
    }

    protected SimpleItemModelBuilder getSimple(ItemLike item) {
        WrappedItemModelBuilder builder = (WrappedItemModelBuilder)this.getBuilder(item);
        if (builder.simpleBuilder == null) {
            builder.simpleBuilder = new SimpleItemModelBuilder(this, builder, item.m_5456_());
        }
        return builder.simpleBuilder;
    }

    protected SimpleItemModelBuilder getSimple(ItemLike item, String name) {
        WrappedItemModelBuilder builder = (WrappedItemModelBuilder)this.getBuilder(name);
        if (builder.simpleBuilder == null) {
            builder.simpleBuilder = new SimpleItemModelBuilder(this, builder, item.m_5456_());
        }
        return builder.simpleBuilder;
    }

    protected SimpleItemModelBuilder getSimple(Supplier<? extends Item> item) {
        return this.getSimple((ItemLike)item.get());
    }

    protected SimpleItemModelBuilder generated(ItemLike item) {
        return this.getSimple(item).parent((ModelFile)GENERATED);
    }

    protected SimpleItemModelBuilder generated(Supplier<? extends Item> item) {
        return this.generated((ItemLike)item.get());
    }

    protected SimpleItemModelBuilder handheld(ItemLike item) {
        return this.getSimple(item).parent((ModelFile)HANDHELD);
    }

    protected SimpleItemModelBuilder handheld(Supplier<? extends Item> item) {
        return this.handheld((ItemLike)item.get());
    }

    protected void simpleItemBlock(Block block) {
        this.getSimple((ItemLike)block).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + this.name((ItemLike)block)))).noTexture();
    }

    private ExistingFileHelper getExistingFileHelper() {
        return this.existingFileHelper;
    }

    private static class WrappedItemModelBuilder
    extends ItemModelBuilder {
        private SimpleItemModelBuilder simpleBuilder;

        public WrappedItemModelBuilder(ResourceLocation outputLocation, ExistingFileHelper existingFileHelper) {
            super(outputLocation, existingFileHelper);
        }

        public JsonObject toJson() {
            if (this.simpleBuilder != null) {
                this.simpleBuilder.build();
                if (this.simpleBuilder.loader != null) {
                    return this.simpleBuilder.loader.toJson(super.toJson());
                }
            }
            return super.toJson();
        }
    }

    public static class SimpleItemModelBuilder {
        private final ItemModelProvider provider;
        private final ItemModelBuilder builder;
        private final Item item;
        private final Map<String, ResourceLocation> layers = new HashMap<String, ResourceLocation>();
        private ModelFile parent;
        private boolean noTexture = false;
        private String folder = "";
        @Nullable
        private CustomLoaderBuilder loader;
        private boolean built = false;

        private SimpleItemModelBuilder(ItemModelProvider provider, ItemModelBuilder builder, Item item) {
            this.provider = provider;
            this.builder = builder;
            this.item = item;
        }

        public SimpleItemModelBuilder parent(ModelFile parent) {
            this.parent = Objects.requireNonNull(parent);
            return this;
        }

        public SimpleItemModelBuilder texture(ResourceLocation texture) {
            if (texture == null) {
                throw new IllegalStateException("Use '.noTexture()' instead of '.texture(null)'");
            }
            return this.texture("layer0", texture);
        }

        public SimpleItemModelBuilder texture(String layer, ResourceLocation texture) {
            if (this.noTexture) {
                throw new IllegalStateException("Unable to set texture. NoTexture set.");
            }
            if (!StringUtils.isEmpty((CharSequence)this.folder)) {
                throw new IllegalArgumentException("Adding texture would ignore existing folder.");
            }
            ResourceLocation existing = this.layers.put(layer, Objects.requireNonNull(texture));
            if (existing != null) {
                LOGGER.warn("Overwriting layer '{}' texture '{}' with '{}'", (Object)layer, (Object)existing, (Object)texture);
            }
            return this;
        }

        public SimpleItemModelBuilder folder(String folder) {
            if (!this.layers.isEmpty()) {
                throw new IllegalStateException("Textures set, folder would be ignored.");
            }
            if (this.noTexture) {
                throw new IllegalStateException("No Texture set, folder would be ignored.");
            }
            this.folder = Objects.requireNonNull(folder);
            return this;
        }

        public SimpleItemModelBuilder noTexture() {
            if (!this.layers.isEmpty()) {
                throw new IllegalStateException("Setting No Texture would ignore textures.");
            }
            if (!StringUtils.isEmpty((CharSequence)this.folder)) {
                throw new IllegalArgumentException("Setting No Texture would ignore existing folder.");
            }
            this.noTexture = true;
            return this;
        }

        public SimpleItemModelBuilder override(Consumer<OverrideBuilder> cons) {
            ItemModelBuilder.OverrideBuilder forgeBuilder = this.builder.override();
            OverrideBuilder builder = new OverrideBuilder(this, forgeBuilder);
            cons.accept(builder);
            return this;
        }

        public <L extends CustomLoaderBuilder> L customLoader(Function<SimpleItemModelBuilder, L> factory) {
            CustomLoaderBuilder loader;
            if (this.loader != null) {
                throw new IllegalStateException("Loader already set!");
            }
            this.loader = loader = (CustomLoaderBuilder)factory.apply(this);
            return (L)loader;
        }

        public ModelFile getModel() {
            return this.builder;
        }

        private void build() {
            if (!this.built) {
                this.builder.parent(this.parent);
                if (!this.noTexture) {
                    if (this.layers.isEmpty()) {
                        this.builder.texture("layer0", this.provider.itemTexture((ItemLike)this.item, this.folder));
                    } else {
                        this.layers.forEach((arg_0, arg_1) -> ((ItemModelBuilder)this.builder).texture(arg_0, arg_1));
                    }
                }
                if (this.loader != null) {
                    this.loader.build(this.builder);
                }
                this.built = true;
            }
        }
    }

    public static class CustomLoaderBuilder {
        protected final ResourceLocation loaderId;
        protected final SimpleItemModelBuilder parent;
        protected final ExistingFileHelper existingFileHelper;
        protected final Map<String, Boolean> visibility = new LinkedHashMap<String, Boolean>();

        protected CustomLoaderBuilder(ResourceLocation loaderId, SimpleItemModelBuilder parent) {
            this.loaderId = loaderId;
            this.parent = parent;
            this.existingFileHelper = parent.provider.getExistingFileHelper();
        }

        public CustomLoaderBuilder visibility(String partName, boolean show) {
            this.visibility.put(partName, show);
            return this;
        }

        public SimpleItemModelBuilder end() {
            return this.parent;
        }

        protected void build(ItemModelBuilder builder) {
        }

        protected JsonObject toJson(JsonObject json) {
            json.addProperty("loader", this.loaderId.toString());
            if (!this.visibility.isEmpty()) {
                JsonObject visibilityObj = new JsonObject();
                for (Map.Entry<String, Boolean> entry : this.visibility.entrySet()) {
                    visibilityObj.addProperty(entry.getKey(), entry.getValue());
                }
                json.add("visibility", (JsonElement)visibilityObj);
            }
            return json;
        }
    }

    public static class OverrideBuilder {
        private final SimpleItemModelBuilder parent;
        private final ItemModelBuilder.OverrideBuilder forgeBuilder;

        public OverrideBuilder(SimpleItemModelBuilder parent, ItemModelBuilder.OverrideBuilder forgeBuilder) {
            this.parent = parent;
            this.forgeBuilder = forgeBuilder;
        }

        public OverrideBuilder model(String name, Consumer<SimpleItemModelBuilder> cons) {
            SimpleItemModelBuilder model = this.parent.provider.getSimple((ItemLike)this.parent.item, name);
            this.forgeBuilder.model(model.getModel());
            cons.accept(model);
            return this;
        }

        public OverrideBuilder predicate(ResourceLocation key, float value) {
            this.forgeBuilder.predicate(key, value);
            return this;
        }
    }
}

