/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item.ingredient;

import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class ModIngredientJS
implements IngredientJS {
    private final String mod;

    public ModIngredientJS(String m) {
        this.mod = m;
        if (RecipeJS.itemErrors && this.getFirst().isEmpty()) {
            throw new RecipeExceptionJS("Mod '" + this.mod + "' doesn't have any items!").error();
        }
    }

    public String getMod() {
        return this.mod;
    }

    @Override
    public boolean test(ItemStackJS stack) {
        return !stack.isEmpty() && this.mod.equals(stack.getMod());
    }

    @Override
    public boolean testVanilla(ItemStack stack) {
        return !stack.m_41619_() && this.mod.equals(KubeJSRegistries.items().getId((Object)stack.m_41720_()).m_135827_());
    }

    @Override
    public boolean testVanillaItem(Item item) {
        return item != Items.f_41852_ && this.mod.equals(KubeJSRegistries.items().getId((Object)item).m_135827_());
    }

    @Override
    public Set<ItemStackJS> getStacks() {
        LinkedHashSet<ItemStackJS> set = new LinkedHashSet<ItemStackJS>();
        for (ItemStackJS stack : ItemStackJS.getList()) {
            if (!this.mod.equals(stack.getMod())) continue;
            set.add(stack);
        }
        return set;
    }

    @Override
    public ItemStackJS getFirst() {
        for (ItemStackJS stack : ItemStackJS.getList()) {
            if (!this.mod.equals(stack.getMod())) continue;
            return stack.copy();
        }
        return ItemStackJS.EMPTY;
    }

    public String toString() {
        return "'@" + this.mod + "'";
    }
}

