/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block.custom;

import dev.latvian.mods.kubejs.BuilderBase;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.RegistryObjectBuilderTypes;
import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.block.BlockStateModifyCallbackJS;
import dev.latvian.mods.kubejs.block.BlockStateModifyPlacementCallbackJS;
import dev.latvian.mods.kubejs.block.EntityBlockKJS;
import dev.latvian.mods.kubejs.block.RandomTickCallbackJS;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import java.util.Collections;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BasicBlockJS
extends Block
implements EntityBlockKJS,
SimpleWaterloggedBlock {
    public final BlockBuilder blockBuilder;
    public final VoxelShape shape;

    public BasicBlockJS(BlockBuilder p) {
        super(p.createProperties());
        this.blockBuilder = p;
        this.shape = p.createShape();
        BlockState blockState = (BlockState)this.f_49792_.m_61090_();
        if (this.blockBuilder.defaultStateModification != null) {
            BlockStateModifyCallbackJS callbackJS = new BlockStateModifyCallbackJS(blockState);
            if (this.safeCallback(this.blockBuilder.defaultStateModification, callbackJS, "Error while creating default blockState for block " + p.id)) {
                this.m_49959_(callbackJS.getState());
            }
        } else if (this.blockBuilder.canBeWaterlogged()) {
            this.m_49959_((BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Override
    public BlockBuilder getBlockBuilderKJS() {
        return this.blockBuilder;
    }

    @Deprecated
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shape;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        BuilderBase<Block> builderBase = RegistryObjectBuilderTypes.BLOCK.getCurrent();
        if (builderBase instanceof BlockBuilder) {
            BlockBuilder current = (BlockBuilder)builderBase;
            for (Property property : current.blockStateProperties) {
                builder.m_61104_(new Property[]{property});
            }
            current.blockStateProperties = Collections.unmodifiableSet(current.blockStateProperties);
        }
    }

    @Deprecated
    public FluidState m_5888_(BlockState state) {
        return state.m_61145_((Property)BlockStateProperties.f_61362_).orElse(false) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockStateModifyPlacementCallbackJS callbackJS;
        if (this.blockBuilder.placementStateModification != null && this.safeCallback(this.blockBuilder.placementStateModification, callbackJS = new BlockStateModifyPlacementCallbackJS(context, this), "Error while modifying BlockState placement of " + this.blockBuilder.id)) {
            return callbackJS.getState();
        }
        if (!this.blockBuilder.canBeWaterlogged()) {
            return this.m_49966_();
        }
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    @Deprecated
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        if (state.m_61145_((Property)BlockStateProperties.f_61362_).orElse(false).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return state;
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.blockBuilder.transparent || state.m_61145_((Property)BlockStateProperties.f_61362_).orElse(false) == false;
    }

    @Deprecated
    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        if (this.blockBuilder.randomTickCallback != null) {
            RandomTickCallbackJS callback = new RandomTickCallbackJS(new BlockContainerJS((Level)level, pos), random);
            this.safeCallback(this.blockBuilder.randomTickCallback, callback, "Error while random ticking custom block " + this);
        }
    }

    public boolean m_6724_(BlockState state) {
        return this.blockBuilder.randomTickCallback != null;
    }

    @Deprecated
    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.blockBuilder.transparent ? Shapes.m_83040_() : super.m_5909_(state, level, pos, ctx);
    }

    @Deprecated
    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.blockBuilder.transparent ? 1.0f : super.m_7749_(state, level, pos);
    }

    @Deprecated
    public boolean m_6104_(BlockState state, BlockState state2, Direction direction) {
        return this.blockBuilder.transparent ? state2.m_60713_((Block)this) || super.m_6104_(state, state2, direction) : super.m_6104_(state, state2, direction);
    }

    @Nullable
    private <T> boolean safeCallback(Consumer<T> consumer, T value, String errorMessage) {
        try {
            consumer.accept(value);
        }
        catch (Throwable e) {
            KubeJS.startupScriptManager.type.console.error(errorMessage, e);
            return false;
        }
        return true;
    }

    public boolean m_6044_(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        if (this.blockBuilder.canBeWaterlogged()) {
            return super.m_6044_(blockGetter, blockPos, blockState, fluid);
        }
        return false;
    }

    public boolean m_7361_(LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState, FluidState fluidState) {
        if (this.blockBuilder.canBeWaterlogged()) {
            return super.m_7361_(levelAccessor, blockPos, blockState, fluidState);
        }
        return false;
    }

    public ItemStack m_142598_(LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState) {
        if (this.blockBuilder.canBeWaterlogged()) {
            return super.m_142598_(levelAccessor, blockPos, blockState);
        }
        return ItemStack.f_41583_;
    }

    public Optional<SoundEvent> m_142298_() {
        if (this.blockBuilder.canBeWaterlogged()) {
            return super.m_142298_();
        }
        return Optional.empty();
    }

    public static class Builder
    extends BlockBuilder {
        public Builder(ResourceLocation i) {
            super(i);
        }

        @Override
        public Block createObject() {
            return new BasicBlockJS(this);
        }
    }
}

