/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.config;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.AlmostUnifiedPlatform;
import com.almostreliable.unified.utils.JsonUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Config {
    public static <T extends Config> T load(String name, Serializer<T> serializer) {
        JsonObject json = Config.safeLoadJson(name);
        T config = serializer.deserialize(json);
        if (serializer.isInvalid()) {
            Path filePath = Config.buildPath(Config.createConfigDir(), name);
            if (Files.exists(filePath, new LinkOption[0])) {
                Config.backupConfig(name, filePath);
            }
            AlmostUnified.LOG.warn("Creating config: {}", (Object)name);
            Config.save(filePath, config, serializer);
        }
        return config;
    }

    private static void backupConfig(String name, Path p) {
        AlmostUnified.LOG.warn("Config {} is invalid. Backing up and recreating.", (Object)name);
        Path backupPath = p.resolveSibling(p.getFileName() + ".bak");
        try {
            Files.deleteIfExists(backupPath);
            Files.move(p, backupPath, new CopyOption[0]);
        }
        catch (IOException e) {
            AlmostUnified.LOG.error("Could not backup config file", (Throwable)e);
        }
    }

    public static <T extends Config> void save(Path p, T config, Serializer<T> serializer) {
        JsonObject json = serializer.serialize(config);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String jsonString = gson.toJson((JsonElement)json);
        try {
            Files.writeString(p, (CharSequence)jsonString, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            AlmostUnified.LOG.error((Object)e);
        }
    }

    private static JsonObject safeLoadJson(String file) {
        JsonObject jsonObject;
        block8: {
            Path p = Config.createConfigDir();
            BufferedReader reader = Files.newBufferedReader(Config.buildPath(p, file));
            try {
                jsonObject = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return new JsonObject();
                }
            }
            reader.close();
        }
        return jsonObject;
    }

    private static Path createConfigDir() {
        Path p = AlmostUnifiedPlatform.INSTANCE.getConfigPath();
        try {
            Files.createDirectories(p, new FileAttribute[0]);
        }
        catch (IOException e) {
            AlmostUnified.LOG.error("Failed to create config directory", (Throwable)e);
        }
        return p;
    }

    private static Path buildPath(Path p, String name) {
        return p.resolve(name + ".json");
    }

    public static abstract class Serializer<T extends Config> {
        private boolean valid = true;

        protected void setInvalid() {
            this.valid = false;
        }

        public boolean isInvalid() {
            return !this.valid;
        }

        public <V> V safeGet(Supplier<V> supplier, V defaultValue) {
            try {
                return supplier.get();
            }
            catch (Exception e) {
                this.setInvalid();
                return defaultValue;
            }
        }

        protected Set<Pattern> deserializePatterns(JsonObject json, String configKey, List<String> defaultValue) {
            return this.safeGet(() -> JsonUtils.toList(json.getAsJsonArray(configKey)).stream().map(Pattern::compile).collect(Collectors.toSet()), new HashSet<Pattern>(defaultValue.stream().map(Pattern::compile).toList()));
        }

        protected void serializePatterns(JsonObject json, String configKey, Set<Pattern> patterns) {
            json.add(configKey, (JsonElement)JsonUtils.toArray(patterns.stream().map(Pattern::pattern).toList()));
        }

        public abstract T deserialize(JsonObject var1);

        public abstract JsonObject serialize(T var1);
    }
}

