/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.util;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.network.NetworkWrapper;
import slimeknights.mantle.network.packet.ISimplePacket;

public class JsonHelper {
    private JsonHelper() {
    }

    public static JsonElement getElement(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return json.get(memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName);
    }

    public static <T> List<T> parseList(JsonArray array, String name, BiFunction<JsonElement, String, T> mapper) {
        if (array.size() == 0) {
            throw new JsonSyntaxException(name + " must have at least 1 element");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < array.size(); ++i) {
            builder.add(mapper.apply(array.get(i), name + "[" + i + "]"));
        }
        return builder.build();
    }

    public static <T> List<T> parseList(JsonArray array, String name, Function<JsonObject, T> mapper) {
        return JsonHelper.parseList(array, name, (JsonElement element, String s) -> mapper.apply(GsonHelper.m_13918_((JsonElement)element, (String)s)));
    }

    public static <T> List<T> parseList(JsonObject parent, String name, BiFunction<JsonElement, String, T> mapper) {
        return JsonHelper.parseList(GsonHelper.m_13933_((JsonObject)parent, (String)name), name, mapper);
    }

    public static <T> List<T> parseList(JsonObject parent, String name, Function<JsonObject, T> mapper) {
        return JsonHelper.parseList(GsonHelper.m_13933_((JsonObject)parent, (String)name), name, mapper);
    }

    public static ResourceLocation getResourceLocation(JsonObject json, String key) {
        String text = GsonHelper.m_13906_((JsonObject)json, (String)key);
        ResourceLocation location = ResourceLocation.m_135820_((String)text);
        if (location == null) {
            throw new JsonSyntaxException("Expected " + key + " to be a Resource location, was '" + text + "'");
        }
        return location;
    }

    public static ResourceLocation convertToResourceLocation(JsonElement json, String key) {
        String text = GsonHelper.m_13805_((JsonElement)json, (String)key);
        ResourceLocation location = ResourceLocation.m_135820_((String)text);
        if (location == null) {
            throw new JsonSyntaxException("Expected " + key + " to be a Resource location, was '" + text + "'");
        }
        return location;
    }

    public static <T extends IForgeRegistryEntry<T>> T convertToEntry(IForgeRegistry<T> registry, JsonElement element, String key) {
        IForgeRegistryEntry value;
        ResourceLocation name = JsonHelper.convertToResourceLocation(element, key);
        if (registry.containsKey(name) && (value = registry.getValue(name)) != null) {
            return (T)value;
        }
        throw new JsonSyntaxException("Unknown " + registry.getRegistryName() + " " + name);
    }

    public static <T extends IForgeRegistryEntry<T>> T getAsEntry(IForgeRegistry<T> registry, JsonObject parent, String key) {
        return JsonHelper.convertToEntry(registry, JsonHelper.getElement(parent, key), key);
    }

    private static <T extends Enum<T>> T enumByName(String name, Class<T> enumClass) {
        for (Enum value : (Enum[])enumClass.getEnumConstants()) {
            if (!value.name().toLowerCase(Locale.ROOT).equals(name)) continue;
            return (T)value;
        }
        throw new JsonSyntaxException("Invalid " + enumClass.getSimpleName() + " " + name);
    }

    public static <T extends Enum<T>> T convertToEnum(JsonElement element, String key, Class<T> enumClass) {
        String name = GsonHelper.m_13805_((JsonElement)element, (String)key);
        return JsonHelper.enumByName(name, enumClass);
    }

    public static <T extends Enum<T>> T getAsEnum(JsonObject json, String key, Class<T> enumClass) {
        String name = GsonHelper.m_13906_((JsonObject)json, (String)key);
        return JsonHelper.enumByName(name, enumClass);
    }

    public static int parseColor(@Nullable String color) {
        if (color == null || color.isEmpty()) {
            return -1;
        }
        if (color.charAt(0) != '-') {
            try {
                int length = color.length();
                if (length == 8) {
                    return (int)Long.parseLong(color, 16);
                }
                if (length == 6) {
                    return 0xFF000000 | Integer.parseInt(color, 16);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new JsonSyntaxException("Invalid color '" + color + "'");
    }

    @Nullable
    public static JsonObject getJson(Resource resource) {
        JsonObject jsonObject;
        BufferedReader reader = new BufferedReader(new InputStreamReader(resource.m_6679_(), StandardCharsets.UTF_8));
        try {
            jsonObject = GsonHelper.m_13859_((Reader)reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonParseException | IOException e) {
                Mantle.logger.error("Failed to load JSON from resource " + resource.m_7843_(), e);
                return null;
            }
        }
        reader.close();
        return jsonObject;
    }

    public static List<JsonObject> getFileInAllDomainsAndPacks(ResourceManager manager, String path, @Nullable String preferredPath) {
        return manager.m_7187_().stream().filter(ResourceLocation::m_135843_).flatMap(namespace -> {
            ResourceLocation location = new ResourceLocation(namespace, path);
            try {
                return manager.m_7396_(location).stream();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException e) {
                Mantle.logger.error("Failed to load JSON files from {}", (Object)location, (Object)e);
            }
            return Stream.empty();
        }).map(preferredPath != null ? resource -> {
            ResourceLocation loaded = resource.m_7843_();
            Mantle.logger.warn("Using deprecated path {} in pack {} - use {}:{} instead", (Object)loaded, (Object)resource.m_7816_(), (Object)loaded.m_135827_(), (Object)preferredPath);
            return JsonHelper.getJson(resource);
        } : JsonHelper::getJson).filter(Objects::nonNull).toList();
    }

    private static void sendPackets(NetworkWrapper network, ServerPlayer player, ISimplePacket[] packets) {
        if (!player.f_8906_.m_6198_().m_129531_()) {
            PacketDistributor.PacketTarget target = PacketDistributor.PLAYER.with(() -> player);
            for (ISimplePacket packet : packets) {
                network.send(target, packet);
            }
        }
    }

    public static void syncPackets(OnDatapackSyncEvent event, NetworkWrapper network, ISimplePacket ... packets) {
        ServerPlayer targetedPlayer = event.getPlayer();
        if (targetedPlayer != null) {
            JsonHelper.sendPackets(network, targetedPlayer, packets);
        } else {
            for (ServerPlayer player : event.getPlayerList().m_11314_()) {
                JsonHelper.sendPackets(network, player, packets);
            }
        }
    }
}

