/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.loot;

import com.google.gson.JsonDeserializer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ObjectHolder;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.loot.AddEntryLootModifier;
import slimeknights.mantle.loot.ReplaceItemLootModifier;
import slimeknights.mantle.loot.condition.BlockTagLootCondition;
import slimeknights.mantle.loot.condition.ContainsItemModifierLootCondition;
import slimeknights.mantle.loot.condition.EmptyModifierLootCondition;
import slimeknights.mantle.loot.condition.ILootModifierCondition;
import slimeknights.mantle.loot.condition.InvertedModifierLootCondition;
import slimeknights.mantle.loot.function.RetexturedLootFunction;
import slimeknights.mantle.loot.function.SetFluidLootFunction;
import slimeknights.mantle.registration.RegistrationHelper;
import slimeknights.mantle.registration.adapter.RegistryAdapter;

@ObjectHolder(value="mantle")
public class MantleLoot {
    public static LootItemConditionType BLOCK_TAG_CONDITION;
    public static LootItemFunctionType RETEXTURED_FUNCTION;
    public static LootItemFunctionType SET_FLUID_FUNCTION;
    public static final AddEntryLootModifier.Serializer ADD_ENTRY;
    public static final ReplaceItemLootModifier.Serializer REPLACE_ITEM;

    public static void registerGlobalLootModifiers(RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
        RegistryAdapter adapter = new RegistryAdapter(event.getRegistry());
        adapter.register(new AddEntryLootModifier.Serializer(), "add_entry");
        adapter.register(new ReplaceItemLootModifier.Serializer(), "replace_item");
        RETEXTURED_FUNCTION = MantleLoot.registerFunction("fill_retextured_block", (Serializer<? extends LootItemFunction>)RetexturedLootFunction.SERIALIZER);
        SET_FLUID_FUNCTION = MantleLoot.registerFunction("set_fluid", (Serializer<? extends LootItemFunction>)SetFluidLootFunction.SERIALIZER);
        BLOCK_TAG_CONDITION = MantleLoot.registerCondition("block_tag", BlockTagLootCondition.SERIALIZER);
        MantleLoot.registerCondition(InvertedModifierLootCondition.ID, (JsonDeserializer<? extends ILootModifierCondition>)((JsonDeserializer)InvertedModifierLootCondition::deserialize));
        MantleLoot.registerCondition(EmptyModifierLootCondition.ID, EmptyModifierLootCondition.INSTANCE);
        MantleLoot.registerCondition(ContainsItemModifierLootCondition.ID, (JsonDeserializer<? extends ILootModifierCondition>)((JsonDeserializer)ContainsItemModifierLootCondition::deserialize));
    }

    private static LootItemFunctionType registerFunction(String name, Serializer<? extends LootItemFunction> serializer) {
        return (LootItemFunctionType)Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)Mantle.getResource(name), (Object)new LootItemFunctionType(serializer));
    }

    private static LootItemConditionType registerCondition(String name, Serializer<? extends LootItemCondition> serializer) {
        return (LootItemConditionType)Registry.m_122965_((Registry)Registry.f_122877_, (ResourceLocation)Mantle.getResource(name), (Object)new LootItemConditionType(serializer));
    }

    private static void registerCondition(ResourceLocation id, JsonDeserializer<? extends ILootModifierCondition> deserializer) {
        ILootModifierCondition.MODIFIER_CONDITIONS.registerDeserializer(id, deserializer);
    }

    private MantleLoot() {
    }

    static {
        ADD_ENTRY = (AddEntryLootModifier.Serializer)((Object)RegistrationHelper.injected());
        REPLACE_ITEM = (ReplaceItemLootModifier.Serializer)((Object)RegistrationHelper.injected());
    }
}

