/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.data.content;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.common.crafting.IShapedRecipe;
import org.apache.commons.lang3.StringUtils;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.BookLoadException;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.data.element.ImageData;
import slimeknights.mantle.client.book.data.element.IngredientData;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.screen.book.Textures;
import slimeknights.mantle.client.screen.book.element.BookElement;
import slimeknights.mantle.client.screen.book.element.ImageElement;
import slimeknights.mantle.client.screen.book.element.ItemElement;
import slimeknights.mantle.client.screen.book.element.TextElement;

public class ContentCrafting
extends PageContent {
    public static final ResourceLocation ID = Mantle.getResource("crafting");
    public static final transient int TEX_SIZE = 256;
    public static final transient ImageData IMG_CRAFTING_LARGE = new ImageData(Textures.TEX_CRAFTING, 0, 0, 183, 114, 256, 256);
    public static final transient ImageData IMG_CRAFTING_SMALL = new ImageData(Textures.TEX_CRAFTING, 0, 114, 155, 78, 256, 256);
    public static final transient int X_RESULT_SMALL = 118;
    public static final transient int Y_RESULT_SMALL = 23;
    public static final transient int X_RESULT_LARGE = 146;
    public static final transient int Y_RESULT_LARGE = 41;
    public static final transient float ITEM_SCALE = 2.0f;
    public static final transient int SLOT_MARGIN = 5;
    public static final transient int SLOT_PADDING = 4;
    public String title = "Crafting";
    public String grid_size = "auto";
    public IngredientData[][] grid;
    public IngredientData result;
    public TextData[] description;
    public String recipe;

    @Override
    public void build(BookData book, ArrayList<BookElement> list, boolean rightSide) {
        String size;
        int y;
        int x = 0;
        int height = 100;
        int resultX = 100;
        int resultY = 50;
        if (this.title == null || this.title.isEmpty()) {
            y = 0;
        } else {
            this.addTitle(list, this.title);
            y = this.getTitleHeight();
        }
        String string = size = this.grid_size.equalsIgnoreCase("auto") ? "large" : this.grid_size;
        if (size.equalsIgnoreCase("small")) {
            x = 91 - ContentCrafting.IMG_CRAFTING_SMALL.width / 2;
            height = y + ContentCrafting.IMG_CRAFTING_SMALL.height;
            list.add(new ImageElement(x, y, ContentCrafting.IMG_CRAFTING_SMALL.width, ContentCrafting.IMG_CRAFTING_SMALL.height, IMG_CRAFTING_SMALL, book.appearance.slotColor));
            resultX = x + 118;
            resultY = y + 23;
        } else if (size.equalsIgnoreCase("large")) {
            x = 91 - ContentCrafting.IMG_CRAFTING_LARGE.width / 2;
            height = y + ContentCrafting.IMG_CRAFTING_LARGE.height;
            list.add(new ImageElement(x, y, ContentCrafting.IMG_CRAFTING_LARGE.width, ContentCrafting.IMG_CRAFTING_LARGE.height, IMG_CRAFTING_LARGE, book.appearance.slotColor));
            resultX = x + 146;
            resultY = y + 41;
        }
        if (this.grid != null) {
            for (int i = 0; i < this.grid.length; ++i) {
                for (int j = 0; j < this.grid[i].length; ++j) {
                    if (this.grid[i][j] == null || this.grid[i][j].getItems().isEmpty()) continue;
                    list.add(new ItemElement(x + 5 + (4 + Math.round(32.0f)) * j, y + 5 + (4 + Math.round(32.0f)) * i, 2.0f, (Collection<ItemStack>)this.grid[i][j].getItems(), this.grid[i][j].action));
                }
            }
        }
        if (this.result != null) {
            list.add(new ItemElement(resultX, resultY, 2.0f, (Collection<ItemStack>)this.result.getItems(), this.result.action));
        }
        if (this.description != null && this.description.length > 0) {
            list.add(new TextElement(0, height + 5, 182, 176 - height - 5, this.description));
        }
    }

    @Override
    public void load() {
        super.load();
        if (!StringUtils.isEmpty((CharSequence)this.recipe) && ResourceLocation.m_135830_((String)this.recipe)) {
            int w = 0;
            int h = 0;
            assert (Minecraft.m_91087_().f_91073_ != null);
            Recipe recipe = Minecraft.m_91087_().f_91073_.m_7465_().m_44043_(new ResourceLocation(this.recipe)).orElse(null);
            if (recipe instanceof CraftingRecipe) {
                if (this.grid_size.equalsIgnoreCase("auto")) {
                    this.grid_size = recipe.m_8004_(2, 2) ? "small" : "large";
                }
                switch (this.grid_size.toLowerCase()) {
                    case "large": {
                        h = 3;
                        w = 3;
                        break;
                    }
                    case "small": {
                        h = 2;
                        w = 2;
                    }
                }
                if (!recipe.m_8004_(w, h)) {
                    throw new BookLoadException("Recipe " + this.recipe + " cannot fit in a " + w + "x" + h + " crafting grid");
                }
                this.result = IngredientData.getItemStackData(recipe.m_8043_());
                NonNullList ingredients = recipe.m_7527_();
                if (recipe instanceof IShapedRecipe) {
                    IShapedRecipe shaped = (IShapedRecipe)recipe;
                    this.grid = new IngredientData[shaped.getRecipeHeight()][shaped.getRecipeWidth()];
                    for (int y = 0; y < this.grid.length; ++y) {
                        for (int x = 0; x < this.grid[y].length; ++x) {
                            this.grid[y][x] = IngredientData.getItemStackData((NonNullList<ItemStack>)NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])((Ingredient)ingredients.get(x + y * this.grid[y].length)).m_43908_()));
                        }
                    }
                    return;
                }
                this.grid = new IngredientData[h][w];
                for (int i = 0; i < ingredients.size(); ++i) {
                    this.grid[i / h][i % w] = IngredientData.getItemStackData((NonNullList<ItemStack>)NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])((Ingredient)ingredients.get(i)).m_43908_()));
                }
            }
        }
    }

    @Override
    public String getTitle() {
        return this.title;
    }
}

