/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.infinity.item;

import com.buuz135.industrial.entity.InfinityLauncherProjectileEntity;
import com.buuz135.industrial.item.infinity.ItemInfinity;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleTool;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.ArrowButtonScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.TextScreenAddon;
import com.hrznstudio.titanium.component.button.ArrowButtonComponent;
import com.hrznstudio.titanium.item.BasicItem;
import com.hrznstudio.titanium.util.FacingUtil;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

public class ItemInfinityLauncher
extends ItemInfinity {
    public static int POWER_CONSUMPTION = 100000;
    public static int FUEL_CONSUMPTION = 30;
    public static String PLUNGER_NBT = "Plunger";

    public ItemInfinityLauncher(CreativeModeTab group) {
        super("infinity_launcher", group, new Item.Properties().m_41487_(1), POWER_CONSUMPTION, FUEL_CONSUMPTION, false);
        this.disableArea();
    }

    public static float getArrowVelocity(int charge) {
        float f = (float)charge / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    @Override
    public void addNbt(ItemStack stack, long power, int fuel, boolean special) {
        super.addNbt(stack, power, fuel, special);
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128405_(PLUNGER_NBT, PlungerAction.RELEASE.getId());
        stack.m_41751_(nbt);
    }

    @Override
    public void addTooltipDetails(BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        super.addTooltipDetails(key, stack, tooltip, advanced);
        PlungerAction action = this.getPlungerAction(stack);
        tooltip.add((Component)new TranslatableComponent("text.industrialforegoing.action").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TranslatableComponent("text.industrialforegoing.launcher." + action.name().toLowerCase(Locale.ROOT)).m_130940_(action.getColor())));
    }

    public PlungerAction getPlungerAction(ItemStack stack) {
        return PlungerAction.getFromId(stack.m_41784_().m_128451_(PLUNGER_NBT));
    }

    public void setPlungerAction(ItemStack stack, PlungerAction plungerAction) {
        stack.m_41784_().m_128405_(PLUNGER_NBT, plungerAction.getId());
    }

    @Override
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 36000;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44986_;
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (!playerIn.m_6144_()) {
            playerIn.m_6672_(handIn);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        int time;
        float velo;
        if (entityLiving instanceof Player && !((double)(velo = ItemInfinityLauncher.getArrowVelocity(time = this.m_8105_(stack) - timeLeft)) < 0.1) && this.enoughFuel(stack)) {
            Player playerentity = (Player)entityLiving;
            playerentity.m_36335_().m_41524_((Item)this, 20);
            if (!worldIn.f_46443_) {
                int k;
                int j;
                InfinityLauncherProjectileEntity abstractarrowentity = new InfinityLauncherProjectileEntity(worldIn, (LivingEntity)playerentity, this.getPlungerAction(stack), ItemInfinityLauncher.getSelectedTier(stack).getRadius());
                abstractarrowentity.m_37251_((Entity)playerentity, playerentity.f_19858_, playerentity.f_19857_, 0.0f, velo * 3.0f, 1.0f);
                if (velo == 1.0f) {
                    abstractarrowentity.m_36762_(true);
                }
                if ((j = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack)) > 0) {
                    abstractarrowentity.m_36781_(abstractarrowentity.m_36789_() + (double)j * 0.5 + 0.5);
                }
                if ((k = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack)) > 0) {
                    abstractarrowentity.m_36735_(k);
                }
                if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0) {
                    abstractarrowentity.m_20254_(100);
                }
                this.consumeFuel(stack);
                abstractarrowentity.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
                worldIn.m_7967_((Entity)abstractarrowentity);
            }
            worldIn.m_6263_((Player)null, playerentity.m_20185_(), playerentity.m_20186_(), playerentity.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (worldIn.f_46441_.nextFloat() * 0.4f + 1.2f) + velo * 0.5f);
            playerentity.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<IFactory<? extends IScreenAddon>> getScreenAddons(final Supplier<ItemStack> stack) {
        List<IFactory<? extends IScreenAddon>> factory = super.getScreenAddons(stack);
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new ArrowButtonScreenAddon((ArrowButtonComponent)new ArrowButtonComponent(154, 52, 14, 14, FacingUtil.Sideness.RIGHT).setId(4))));
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new ArrowButtonScreenAddon((ArrowButtonComponent)new ArrowButtonComponent(54, 52, 14, 14, FacingUtil.Sideness.LEFT).setId(5))));
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new TextScreenAddon("", 72, 56, false){

            public String getText() {
                PlungerAction action = ItemInfinityLauncher.this.getPlungerAction((ItemStack)stack.get());
                return ChatFormatting.DARK_GRAY + new TranslatableComponent("text.industrialforegoing.action").m_130940_(ChatFormatting.GRAY).getString() + action.getColor() + new TranslatableComponent("text.industrialforegoing.launcher." + action.name().toLowerCase(Locale.ROOT)).m_130940_(action.getColor()).getString();
            }
        }));
        return factory;
    }

    @Override
    public void handleButtonMessage(int id, Player playerEntity, CompoundTag compound) {
        super.handleButtonMessage(id, playerEntity, compound);
        ItemStack stack = playerEntity.m_21120_(InteractionHand.MAIN_HAND);
        PlungerAction plungerAction = this.getPlungerAction(stack);
        if (id == 4) {
            this.setPlungerAction(stack, PlungerAction.getFromId(plungerAction.getId() + 1));
        }
        if (id == 5) {
            this.setPlungerAction(stack, PlungerAction.getFromId(plungerAction.getId() - 1));
        }
    }

    @Override
    public void registerRecipe(Consumer<FinishedRecipe> consumer) {
        new DissolutionChamberRecipe(this.getRegistryName(), new Ingredient.Value[]{new Ingredient.ItemValue(new ItemStack((ItemLike)Items.f_41959_)), new Ingredient.ItemValue(new ItemStack((ItemLike)Items.f_42411_)), new Ingredient.ItemValue(new ItemStack((ItemLike)Items.f_41959_)), new Ingredient.ItemValue(new ItemStack((ItemLike)ModuleTool.MOB_IMPRISONMENT_TOOL.get())), new Ingredient.ItemValue(new ItemStack((ItemLike)ModuleCore.RANGE_ADDONS[11].get())), new Ingredient.TagValue(IndustrialTags.Items.GEAR_GOLD), new Ingredient.TagValue(IndustrialTags.Items.GEAR_GOLD), new Ingredient.TagValue(IndustrialTags.Items.GEAR_GOLD)}, new FluidStack((Fluid)ModuleCore.PINK_SLIME.getSourceFluid().get(), 2000), 400, new ItemStack((ItemLike)this), FluidStack.EMPTY);
    }

    public static enum PlungerAction {
        RELEASE(0, ChatFormatting.GREEN),
        CAPTURE(1, ChatFormatting.GOLD),
        DAMAGE(2, ChatFormatting.RED);

        private final int id;
        private final ChatFormatting color;

        private PlungerAction(int id, ChatFormatting color) {
            this.id = id;
            this.color = color;
        }

        public static PlungerAction getFromId(int id) {
            if (id < 0) {
                return DAMAGE;
            }
            for (PlungerAction value : PlungerAction.values()) {
                if (value.id != id) continue;
                return value;
            }
            return RELEASE;
        }

        public int getId() {
            return this.id;
        }

        public ChatFormatting getColor() {
            return this.color;
        }
    }
}

