/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item;

import com.buuz135.industrial.api.straw.StrawHandler;
import com.buuz135.industrial.item.IFCustomItem;
import com.buuz135.industrial.utils.IndustrialTags;
import com.buuz135.industrial.utils.StrawUtils;
import com.hrznstudio.titanium.item.BasicItem;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ItemStraw
extends IFCustomItem {
    public ItemStraw(CreativeModeTab group) {
        super("straw", group, new Item.Properties().m_41487_(1));
    }

    @Nonnull
    public ItemStack m_5922_(@Nonnull ItemStack heldStack, Level world, LivingEntity entity) {
        Player player;
        BlockHitResult result;
        if (!world.f_46443_ && entity instanceof Player && (result = ItemStraw.m_41435_((Level)world, (Player)(player = (Player)entity), (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY)) != null && result.m_6662_() == HitResult.Type.BLOCK) {
            LazyOptional fluidhandlercap;
            BlockHitResult blockRayTraceResult = result;
            BlockPos pos = blockRayTraceResult.m_82425_();
            BlockState state = world.m_8055_(pos);
            Block block = state.m_60734_();
            FluidState fluidState = state.m_60819_();
            if (fluidState != Fluids.f_76191_.m_76145_() && block instanceof BucketPickup && fluidState.m_76170_()) {
                StrawUtils.getStrawHandler(fluidState.m_76152_()).ifPresent(handler -> {
                    ItemStack stack = ((BucketPickup)block).m_142598_((LevelAccessor)world, pos, state);
                    stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(iFluidHandlerItem -> {
                        if (!iFluidHandlerItem.getFluidInTank(0).isEmpty()) {
                            handler.onDrink(world, pos, iFluidHandlerItem.getFluidInTank(0).getFluid(), player, false);
                        }
                    });
                });
                return heldStack;
            }
            BlockEntity tile = world.m_7702_(pos);
            if (tile != null && (fluidhandlercap = tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)).isPresent()) {
                IFluidHandler handler2 = (IFluidHandler)fluidhandlercap.orElseThrow(RuntimeException::new);
                int tanks = handler2.getTanks();
                for (int i = 0; i < tanks; ++i) {
                    FluidStack out;
                    FluidStack stack = handler2.getFluidInTank(i);
                    if (stack.isEmpty()) continue;
                    Fluid fluidInstance = stack.getFluid();
                    Optional<StrawHandler> strawHandler = StrawUtils.getStrawHandler(fluidInstance);
                    if (fluidInstance == null || !strawHandler.isPresent() || stack.getAmount() < 1000 || (out = handler2.drain(1000, IFluidHandler.FluidAction.SIMULATE)).isEmpty() || out.getAmount() < 1000) continue;
                    strawHandler.ifPresent(straw -> straw.onDrink(world, pos, out.getFluid(), player, true));
                    handler2.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                }
            }
        }
        return super.m_5922_(heldStack, world, entity);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, @Nonnull InteractionHand handIn) {
        BlockHitResult result = ItemStraw.m_41435_((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (result != null && result.m_6662_() == HitResult.Type.BLOCK) {
            LazyOptional fluidhandlercap;
            Optional<StrawHandler> handler;
            BlockHitResult blockRayTraceResult = result;
            BlockPos pos = blockRayTraceResult.m_82425_();
            BlockState state = worldIn.m_8055_(pos);
            Block block = state.m_60734_();
            FluidState fluid = state.m_60819_();
            if (fluid != null && (handler = StrawUtils.getStrawHandler(fluid.m_76152_())).isPresent()) {
                playerIn.m_6672_(handIn);
                return InteractionResultHolder.m_19090_((Object)playerIn.m_21120_(handIn));
            }
            BlockEntity tile = worldIn.m_7702_(pos);
            if (tile != null && (fluidhandlercap = tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)).isPresent()) {
                IFluidHandler handler2 = (IFluidHandler)fluidhandlercap.orElseThrow(RuntimeException::new);
                int tanks = handler2.getTanks();
                for (int i = 0; i < tanks; ++i) {
                    FluidStack out;
                    FluidStack stack = handler2.getFluidInTank(i);
                    if (stack.isEmpty()) continue;
                    Fluid fluidInstance = stack.getFluid();
                    Optional<StrawHandler> strawHandler = StrawUtils.getStrawHandler(fluidInstance);
                    if (fluidInstance == null || !strawHandler.isPresent() || stack.getAmount() < 1000 || (out = handler2.drain(stack, IFluidHandler.FluidAction.SIMULATE)) == null || out.getAmount() < 1000) continue;
                    playerIn.m_6672_(handIn);
                    return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.m_21120_(handIn));
                }
            }
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public int m_8105_(ItemStack p_77626_1_) {
        return 30;
    }

    public UseAnim m_6164_(ItemStack p_77661_1_) {
        return UseAnim.DRINK;
    }

    public boolean hasTooltipDetails(@Nullable BasicItem.Key key) {
        return key == null;
    }

    public void addTooltipDetails(@Nullable BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        super.addTooltipDetails(key, stack, tooltip, advanced);
        tooltip.add((Component)new TextComponent(ChatFormatting.GRAY + "\"The One Who Codes\""));
    }

    public void registerRecipe(Consumer<FinishedRecipe> consumer) {
        TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this).m_126130_("PP ").m_126130_(" P ").m_126130_(" P ").m_206416_(Character.valueOf('P'), IndustrialTags.Items.PLASTIC).m_176498_(consumer);
    }
}

