/*
 * Decompiled with CFR 0.152.
 */
package com.tabithastrong.compactstorage.item;

import com.tabithastrong.compactstorage.CompactStorage;
import com.tabithastrong.compactstorage.inventory.BackpackInventory;
import com.tabithastrong.compactstorage.inventory.BackpackInventoryHandlerFactory;
import com.tabithastrong.compactstorage.util.CompactStorageUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class BackpackItem
extends Item {
    public BackpackItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (!world.f_46443_) {
            InteractionHand oppositeHand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
            ItemStack oppositeHandStack = player.m_21120_(oppositeHand);
            ItemStack heldItem = player.m_21120_(hand);
            if (!heldItem.m_41782_()) {
                CompactStorage.LOGGER.warn("no nbt");
                heldItem.m_41751_(new CompoundTag());
            }
            if (!oppositeHandStack.m_41619_()) {
                Item oppositeHandItem = oppositeHandStack.m_41720_();
                BackpackInventory inventory = new BackpackInventory(heldItem.m_41783_().m_128469_("Backpack"), hand, player);
                if (oppositeHandItem == CompactStorage.UPGRADE_ROW_ITEM.get()) {
                    if (inventory.increaseSize(1, 0)) {
                        player.m_21120_(oppositeHand).m_41774_(1);
                        heldItem.m_41783_().m_128365_("Backpack", (Tag)inventory.toTag());
                        player.m_5661_((Component)new TranslatableComponent("text.compact_storage.upgrade_success").m_130940_(ChatFormatting.GREEN), true);
                        player.m_6330_(SoundEvents.f_12275_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        return InteractionResultHolder.m_19098_((Object)heldItem);
                    }
                    player.m_6330_(SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    player.m_5661_((Component)new TranslatableComponent("text.compact_storage.upgrade_fail_maxsize").m_130940_(ChatFormatting.RED), true);
                    return InteractionResultHolder.m_19100_((Object)heldItem);
                }
                if (oppositeHandItem == CompactStorage.UPGRADE_COLUMN_ITEM.get()) {
                    if (inventory.increaseSize(0, 1)) {
                        player.m_21120_(oppositeHand).m_41774_(1);
                        heldItem.m_41783_().m_128365_("Backpack", (Tag)inventory.toTag());
                        player.m_5661_((Component)new TranslatableComponent("text.compact_storage.upgrade_success").m_130940_(ChatFormatting.GREEN), true);
                        player.m_6330_(SoundEvents.f_12275_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        return InteractionResultHolder.m_19098_((Object)heldItem);
                    }
                    player.m_6330_(SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    player.m_5661_((Component)new TranslatableComponent("text.compact_storage.upgrade_fail_maxsize").m_130940_(ChatFormatting.RED), true);
                    return InteractionResultHolder.m_19100_((Object)heldItem);
                }
                if (oppositeHandItem instanceof DyeItem) {
                    DyeItem dyeItem = (DyeItem)oppositeHandItem;
                    ItemStack newStack = new ItemStack((ItemLike)CompactStorage.DYE_COLOR_TO_BACKPACK_MAP.get(dyeItem.m_41089_()).get(), 1);
                    newStack.m_41751_(heldItem.m_41783_());
                    player.m_6330_(SoundEvents.f_12392_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    player.m_21120_(oppositeHand).m_41774_(1);
                    return InteractionResultHolder.m_19098_((Object)newStack);
                }
            }
            BackpackInventoryHandlerFactory backpackInventoryHandlerFactory = new BackpackInventoryHandlerFactory(player, hand);
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)backpackInventoryHandlerFactory, backpackInventoryHandlerFactory::writeScreenOpeningData);
        }
        return super.m_7203_(world, player, hand);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        super.m_7373_(stack, world, tooltip, context);
        CompactStorageUtil.appendTooltip(stack, (BlockGetter)world, tooltip, context, true);
    }
}

