/*
 * Decompiled with CFR 0.152.
 */
package com.tabithastrong.compactstorage.block;

import com.tabithastrong.compactstorage.CompactStorage;
import com.tabithastrong.compactstorage.block.entity.CompactBarrelBlockEntity;
import com.tabithastrong.compactstorage.util.CompactStorageUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class CompactBarrelBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = DirectionProperty.m_156003_((String)"facing");
    public static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");

    public CompactBarrelBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)ctx.m_7820_().m_122424_())).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, OPEN});
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        BlockEntity blockEntity;
        CompoundTag nbt;
        BlockEntity blockEntity2;
        super.m_6402_(world, pos, state, placer, itemStack);
        if (itemStack.m_41788_() && (blockEntity2 = world.m_7702_(pos)) instanceof CompactBarrelBlockEntity) {
            CompactBarrelBlockEntity compactBarrelBlockEntity = (CompactBarrelBlockEntity)blockEntity2;
            compactBarrelBlockEntity.m_58638_(itemStack.m_41786_());
        }
        if (!world.f_46443_ && itemStack.m_41782_() && (nbt = itemStack.m_41783_()).m_128441_("inventory_width") && nbt.m_128441_("inventory_height") && (blockEntity = world.m_7702_(pos)) instanceof CompactBarrelBlockEntity) {
            CompactBarrelBlockEntity compactBarrelBlockEntity = (CompactBarrelBlockEntity)blockEntity;
            compactBarrelBlockEntity.inventoryWidth = nbt.m_128451_("inventory_width");
            compactBarrelBlockEntity.inventoryHeight = nbt.m_128451_("inventory_height");
            compactBarrelBlockEntity.resizeInventory();
            compactBarrelBlockEntity.m_6596_();
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!world.f_46443_ && !world.f_46443_ && (blockEntity = world.m_7702_(pos)) instanceof CompactBarrelBlockEntity) {
            CompactBarrelBlockEntity compactBarrelBlockEntity = (CompactBarrelBlockEntity)blockEntity;
            Item heldItem = player.m_21120_(hand).m_41720_();
            if (heldItem == CompactStorage.UPGRADE_ROW_ITEM.get()) {
                if (compactBarrelBlockEntity.increaseSize(1, 0)) {
                    player.m_21120_(hand).m_41774_(1);
                    player.m_5661_((Component)new TranslatableComponent("text.compact_storage.upgrade_success").m_130940_(ChatFormatting.GREEN), true);
                    player.m_6330_(SoundEvents.f_12275_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.CONSUME_PARTIAL;
                }
                player.m_6330_(SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
                player.m_5661_((Component)new TranslatableComponent("text.compact_storage.upgrade_fail_maxsize").m_130940_(ChatFormatting.RED), true);
                return InteractionResult.FAIL;
            }
            if (heldItem == CompactStorage.UPGRADE_COLUMN_ITEM.get()) {
                if (compactBarrelBlockEntity.increaseSize(0, 1)) {
                    player.m_21120_(hand).m_41774_(1);
                    player.m_5661_((Component)new TranslatableComponent("text.compact_storage.upgrade_success").m_130940_(ChatFormatting.GREEN), true);
                    player.m_6330_(SoundEvents.f_12275_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.CONSUME_PARTIAL;
                }
                player.m_6330_(SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
                player.m_5661_((Component)new TranslatableComponent("text.compact_storage.upgrade_fail_maxsize").m_130940_(ChatFormatting.RED), true);
                return InteractionResult.FAIL;
            }
            if (heldItem instanceof DyeItem) {
                DyeItem dyeItem = (DyeItem)heldItem;
                Block newBlock = (Block)CompactStorage.DYE_COLOR_TO_COMPACT_BARREL_MAP.get(dyeItem.m_41089_()).get();
                world.m_46597_(pos, (BlockState)newBlock.m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))));
                player.m_6330_(SoundEvents.f_12392_, SoundSource.BLOCKS, 1.0f, 1.0f);
                player.m_21120_(hand).m_41774_(1);
                return InteractionResult.CONSUME_PARTIAL;
            }
            MenuProvider screenHandlerFactory = state.m_60750_(world, pos);
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)screenHandlerFactory, compactBarrelBlockEntity::writeScreenOpeningData);
        }
        return InteractionResult.SUCCESS;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (newState.m_60734_() instanceof CompactBarrelBlock && newState.m_61143_((Property)FACING) == state.m_61143_((Property)FACING)) {
            return;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof CompactBarrelBlockEntity) {
            CompactBarrelBlockEntity compactBarrelBlockEntity = (CompactBarrelBlockEntity)blockEntity;
            ItemStack chestStack = new ItemStack((ItemLike)this, 1);
            CompoundTag chestTag = new CompoundTag();
            chestTag.m_128405_("inventory_width", compactBarrelBlockEntity.inventoryWidth);
            chestTag.m_128405_("inventory_height", compactBarrelBlockEntity.inventoryHeight);
            if (compactBarrelBlockEntity.inventoryWidth != 9 || compactBarrelBlockEntity.inventoryHeight != 6) {
                chestStack.m_41751_(chestTag);
            }
            if (compactBarrelBlockEntity.m_8077_()) {
                chestStack.m_41714_(compactBarrelBlockEntity.m_7770_());
            }
            Containers.m_19002_((Level)world, (BlockPos)pos, (Container)compactBarrelBlockEntity);
            Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)chestStack);
            world.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, world, pos, newState, moved);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag options) {
        super.m_5871_(stack, world, tooltip, options);
        CompactStorageUtil.appendTooltip(stack, world, tooltip, options, false);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)world.m_7702_(pos));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CompactBarrelBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return CompactBarrelBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)CompactStorage.COMPACT_BARREL_ENTITY_TYPE.get()), (world1, pos, state1, be) -> CompactBarrelBlockEntity.tick(world1, pos, state1, be));
    }
}

