/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.block.entity;

import com.tom.createores.block.IOBlock;
import com.tom.createores.block.entity.ExcavatingBlockEntity;
import com.tom.createores.recipe.ExtractorRecipe;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class ExtractorBlockEntity
extends ExcavatingBlockEntity<ExtractorRecipe> {
    private Tank fluidTank = new Tank();
    private LazyOptional<FluidTank> tankCap = LazyOptional.of(() -> this.fluidTank);

    public ExtractorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public <T> LazyOptional<T> getCaps(Capability<T> cap, IOBlock.Type type) {
        if (type == IOBlock.Type.FLUID_OUT && cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tankCap.cast();
        }
        return LazyOptional.empty();
    }

    @Override
    protected boolean instanceofCheck(Object rec) {
        return rec instanceof ExtractorRecipe;
    }

    @Override
    protected boolean canExtract() {
        return this.fluidTank.fillInternal(((ExtractorRecipe)this.current).getOutput(), IFluidHandler.FluidAction.SIMULATE) == ((ExtractorRecipe)this.current).getOutput().getAmount();
    }

    @Override
    protected void onFinished() {
        this.fluidTank.fillInternal(((ExtractorRecipe)this.current).getOutput(), IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.fluidTank.readFromNBT(tag.m_128469_("tank"));
    }

    @Override
    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128365_("tank", (Tag)this.fluidTank.writeToNBT(new CompoundTag()));
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        this.containedFluidTooltip(tooltip, isPlayerSneaking, this.tankCap.cast());
        return true;
    }

    public void invalidate() {
        super.invalidate();
        this.tankCap.invalidate();
    }

    private class Tank
    extends FluidTank {
        public Tank() {
            super(16000);
        }

        protected void onContentsChanged() {
            ExtractorBlockEntity.this.notifyUpdate();
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        public int fillInternal(FluidStack resource, IFluidHandler.FluidAction action) {
            return super.fill(resource, action);
        }
    }
}

