/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.net;

import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.common.blockentity.FramedSignBlockEntity;

public class SignUpdatePacket {
    private final BlockPos pos;
    private final String[] lines;

    public SignUpdatePacket(BlockPos pos, String[] lines) {
        this.pos = pos;
        this.lines = lines;
    }

    public SignUpdatePacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        int count = buffer.readByte();
        this.lines = new String[count];
        for (int i = 0; i < count; ++i) {
            this.lines[i] = buffer.m_130136_(384);
        }
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeByte(this.lines.length);
        for (String line : this.lines) {
            buffer.m_130070_(line);
        }
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockEntity patt1684$temp;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            ServerLevel level = player.m_183503_();
            if (level.m_46805_(this.pos) && (patt1684$temp = level.m_7702_(this.pos)) instanceof FramedSignBlockEntity) {
                FramedSignBlockEntity sign = (FramedSignBlockEntity)patt1684$temp;
                if (sign.getEditingPlayer() != player) {
                    FramedBlocks.LOGGER.warn("Player " + player + " tried to edit sign at " + this.pos);
                    return;
                }
                for (int i = 0; i < this.lines.length; ++i) {
                    String line = ChatFormatting.m_126649_((String)this.lines[i]);
                    sign.setLine(i, (Component)new TextComponent(line != null ? line : ""));
                }
            }
        });
        return true;
    }
}

