/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.util.DoubleSoundMode;

public class FramedDoublePrismBlockEntity
extends FramedDoubleBlockEntity {
    public FramedDoublePrismBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)FBContent.blockEntityTypeFramedDoublePrism.get(), pos, state);
    }

    protected FramedDoublePrismBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    protected boolean hitSecondary(BlockHitResult hit) {
        Direction facing;
        Direction side = hit.m_82434_();
        if (side == (facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_))) {
            return true;
        }
        if (side == facing.m_122424_()) {
            return false;
        }
        if (!this.isDoubleSide(side) && side.m_122434_() != facing.m_122434_()) {
            return false;
        }
        if (this.isDoubleSide(side)) {
            Direction horDir = side.m_175362_(facing.m_122434_());
            double hor = Utils.fractionInDir(hit.m_82450_(), horDir);
            hor = Math.abs(hor - 0.5);
            double vert = Utils.fractionInDir(hit.m_82450_(), facing) - 0.5;
            return vert > hor;
        }
        return false;
    }

    @Override
    public DoubleSoundMode getSoundMode() {
        if (this.isDoubleSide(Direction.UP)) {
            return DoubleSoundMode.EITHER;
        }
        if (this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_) == Direction.DOWN) {
            return DoubleSoundMode.SECOND;
        }
        return DoubleSoundMode.FIRST;
    }

    @Override
    public BlockState getCamoState(Direction side) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        if (side == facing) {
            return this.getCamoStateTwo();
        }
        if (this.isDoubleSide(side)) {
            return Blocks.f_50016_.m_49966_();
        }
        return this.getCamoState();
    }

    @Override
    public boolean isSolidSide(Direction side) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        if (side == facing) {
            return this.getCamoStateTwo().m_60804_((BlockGetter)this.f_58857_, this.f_58858_);
        }
        if (this.isDoubleSide(side)) {
            return false;
        }
        return this.getCamoState().m_60804_((BlockGetter)this.f_58857_, this.f_58858_);
    }

    protected boolean isDoubleSide(Direction side) {
        return side.m_122434_() == this.m_58900_().m_61143_((Property)BlockStateProperties.f_61365_);
    }
}

