/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.util.FramedBlockData;
import xfacthd.framedblocks.api.util.client.ClientUtils;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.util.DoubleBlockSoundType;
import xfacthd.framedblocks.common.util.DoubleSoundMode;

public abstract class FramedDoubleBlockEntity
extends FramedBlockEntity {
    public static final ModelProperty<IModelData> DATA_LEFT = new ModelProperty();
    public static final ModelProperty<IModelData> DATA_RIGHT = new ModelProperty();
    private final IModelData multiModelData = new ModelDataMap.Builder().build();
    private final FramedBlockData modelData = new FramedBlockData(false);
    private final DoubleBlockSoundType soundType = new DoubleBlockSoundType(this);
    private Tuple<BlockState, BlockState> blockPair;
    private ItemStack camoStack = ItemStack.f_41583_;
    private BlockState camoState = Blocks.f_50016_.m_49966_();

    public FramedDoubleBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.blockPair = AbstractFramedDoubleBlock.getStatePair(state);
    }

    @Override
    public void setCamo(ItemStack camoStack, BlockState camoState, boolean secondary) {
        if (secondary) {
            int light = this.getLightValue();
            this.camoStack = camoStack;
            this.camoState = camoState;
            this.m_6596_();
            if (this.getLightValue() != light) {
                this.doLightUpdate();
            }
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        } else {
            super.setCamo(camoStack, camoState, false);
        }
    }

    @Override
    public BlockState getCamoState(BlockState state) {
        if (state == this.blockPair.m_14418_()) {
            return this.getCamoState();
        }
        if (state == this.blockPair.m_14419_()) {
            return this.getCamoStateTwo();
        }
        return Blocks.f_50016_.m_49966_();
    }

    @Override
    protected void applyCamo(ItemStack camoStack, BlockState camoState, BlockHitResult hit) {
        if (this.hitSecondary(hit)) {
            this.camoStack = camoStack;
            this.camoState = camoState;
        } else {
            super.applyCamo(camoStack, camoState, hit);
        }
    }

    public BlockState getCamoStateTwo() {
        return this.camoState;
    }

    public ItemStack getCamoStackTwo() {
        return this.camoStack;
    }

    @Override
    public int getLightValue() {
        return Math.max(this.camoState.m_60791_(), super.getLightValue());
    }

    @Override
    public void addCamoDrops(List<ItemStack> drops) {
        super.addCamoDrops(drops);
        if (!this.camoStack.m_41619_()) {
            drops.add(this.camoStack);
        }
    }

    @Override
    public MaterialColor getMapColor() {
        if (!this.camoState.m_60795_()) {
            return this.camoState.m_60780_((BlockGetter)this.f_58857_, this.f_58858_);
        }
        return super.getMapColor();
    }

    @Override
    public float[] getCamoBeaconColorMultiplier(LevelReader level, BlockPos pos, BlockPos beaconPos) {
        float[] localMult;
        float[] superMult = super.getCamoBeaconColorMultiplier(level, pos, beaconPos);
        float[] fArray = localMult = this.camoState.m_60795_() ? null : this.camoState.getBeaconColorMultiplier(level, pos, beaconPos);
        if (superMult == null) {
            return localMult;
        }
        if (localMult == null) {
            return superMult;
        }
        return new float[]{(superMult[0] + localMult[0]) / 2.0f, (superMult[1] + localMult[1]) / 2.0f, (superMult[2] + localMult[2]) / 2.0f};
    }

    @Override
    protected BlockState getCamoState(BlockHitResult hit) {
        return this.hitSecondary(hit) ? this.getCamoStateTwo() : this.getCamoState();
    }

    @Override
    protected ItemStack getCamoStack(BlockHitResult hit) {
        return this.hitSecondary(hit) ? this.getCamoStackTwo() : this.getCamoStack();
    }

    @Override
    public boolean shouldCamoDisplayFluidOverlay(BlockAndTintGetter level, BlockPos pos, FluidState fluid) {
        if (this.camoState.m_60795_() || this.camoState.shouldDisplayFluidOverlay(level, pos, fluid)) {
            return true;
        }
        return super.shouldCamoDisplayFluidOverlay(level, pos, fluid);
    }

    @Override
    protected boolean isCamoSolid() {
        return super.isCamoSolid() && !this.camoState.m_60795_() && this.camoState.m_60804_((BlockGetter)this.f_58857_, this.f_58858_);
    }

    @Override
    public float getCamoExplosionResistance(Explosion explosion) {
        return Math.max(super.getCamoExplosionResistance(explosion), this.getCamoStateTwo().getExplosionResistance((BlockGetter)this.f_58857_, this.f_58858_, explosion));
    }

    @Override
    public boolean isCamoFlammable(Direction face) {
        BlockState camo = this.getCamoState(face);
        if (!(!camo.m_60795_() || this.getCamoState().m_60795_() && this.getCamoStateTwo().m_60795_())) {
            return !(!this.getCamoState().m_60795_() && !this.getCamoState().isFlammable((BlockGetter)this.f_58857_, this.f_58858_, face) || !this.getCamoStateTwo().m_60795_() && !this.getCamoStateTwo().isFlammable((BlockGetter)this.f_58857_, this.f_58858_, face));
        }
        if (!camo.m_60795_()) {
            return camo.isFlammable((BlockGetter)this.f_58857_, this.f_58858_, face);
        }
        return true;
    }

    @Override
    public int getCamoFlammability(Direction face) {
        int flammabilityTwo;
        int flammabilityOne = super.getCamoFlammability(face);
        int n = flammabilityTwo = this.getCamoStateTwo().m_60795_() ? -1 : this.getCamoStateTwo().getFlammability((BlockGetter)this.f_58857_, this.f_58858_, face);
        if (flammabilityOne == -1) {
            return flammabilityTwo;
        }
        if (flammabilityTwo == -1) {
            return flammabilityOne;
        }
        return Math.min(flammabilityOne, flammabilityTwo);
    }

    @Override
    public int getCamoFireSpreadSpeed(Direction face) {
        int spreadSpeedTwo;
        int spreadSpeedOne = super.getCamoFireSpreadSpeed(face);
        int n = spreadSpeedTwo = this.getCamoStateTwo().m_60795_() ? -1 : this.getCamoStateTwo().getFireSpreadSpeed((BlockGetter)this.f_58857_, this.f_58858_, face);
        if (spreadSpeedOne == -1) {
            return spreadSpeedOne;
        }
        if (spreadSpeedTwo == -1) {
            return spreadSpeedTwo;
        }
        return Math.min(spreadSpeedOne, spreadSpeedTwo);
    }

    public final DoubleBlockSoundType getSoundType() {
        return this.soundType;
    }

    protected abstract boolean hitSecondary(BlockHitResult var1);

    public abstract DoubleSoundMode getSoundMode();

    @Override
    public boolean updateCulling(Direction side, boolean rerender) {
        boolean changed = this.updateCulling(this.getModelDataInternal(), (BlockState)this.blockPair.m_14418_(), side, rerender);
        return changed |= this.updateCulling(this.modelData, (BlockState)this.blockPair.m_14419_(), side, rerender);
    }

    public void m_155250_(BlockState state) {
        BlockState oldState = this.m_58900_();
        super.m_155250_(state);
        if (state != oldState) {
            this.blockPair = AbstractFramedDoubleBlock.getStatePair(state);
        }
    }

    @Override
    protected void writeToDataPacket(CompoundTag nbt) {
        super.writeToDataPacket(nbt);
        nbt.m_128365_("camo_stack_two", (Tag)this.camoStack.m_41739_(new CompoundTag()));
        nbt.m_128365_("camo_state_two", (Tag)NbtUtils.m_129202_((BlockState)this.camoState));
    }

    @Override
    protected boolean readFromDataPacket(CompoundTag nbt) {
        this.camoStack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("camo_stack_two"));
        boolean needUpdate = false;
        BlockState newState = NbtUtils.m_129241_((CompoundTag)nbt.m_128469_("camo_state_two"));
        if (newState != this.camoState) {
            this.camoState = newState;
            this.modelData.setCamoState(this.camoState);
            needUpdate = true;
            this.updateCulling(true, false);
        }
        return super.readFromDataPacket(nbt) || needUpdate;
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128365_("camo_stack_two", (Tag)this.camoStack.m_41739_(new CompoundTag()));
        nbt.m_128365_("camo_state_two", (Tag)NbtUtils.m_129202_((BlockState)this.camoState));
        return nbt;
    }

    @Override
    public void handleUpdateTag(CompoundTag nbt) {
        super.handleUpdateTag(nbt);
        this.camoStack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("camo_stack_two"));
        BlockState newState = NbtUtils.m_129241_((CompoundTag)nbt.m_128469_("camo_state_two"));
        if (newState != this.camoState) {
            this.camoState = newState;
            this.modelData.setCamoState(this.camoState);
            ClientUtils.enqueueClientTask(() -> this.updateCulling(true, true));
        }
    }

    @Override
    public IModelData getModelData() {
        this.multiModelData.setData(DATA_LEFT, (Object)super.getModelData());
        this.multiModelData.setData(DATA_RIGHT, (Object)this.modelData);
        return this.multiModelData;
    }

    @Override
    protected void initModelData() {
        super.initModelData();
        this.modelData.setCamoState(this.camoState);
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("camo_stack_two", (Tag)this.camoStack.m_41739_(new CompoundTag()));
        nbt.m_128365_("camo_state_two", (Tag)NbtUtils.m_129202_((BlockState)this.camoState));
        super.m_183515_(nbt);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        BlockState state = NbtUtils.m_129241_((CompoundTag)nbt.m_128469_("camo_state_two"));
        if (state.m_60795_() || this.isValidBlock(state, null)) {
            this.camoStack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("camo_stack_two"));
            this.camoState = state;
        } else {
            FramedBlocks.LOGGER.warn("Framed Block of type \"{}\" at position {} contains an invalid camo of type \"{}\", removing camo! This might be caused by a config or tag change!", new Object[]{this.m_58900_().m_60734_().getRegistryName(), this.f_58858_, state.m_60734_().getRegistryName()});
        }
    }
}

