/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.cube;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.util.CtmPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.blockentity.FramedOwnableBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.NullableDirection;
import xfacthd.framedblocks.common.util.ServerConfig;

public class FramedOneWayWindowBlock
extends FramedBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, side) -> {
        NullableDirection face = (NullableDirection)((Object)((Object)state.m_61143_(PropertyHolder.NULLABLE_FACE)));
        return side != null && side != face.toDirection();
    };

    public FramedOneWayWindowBlock() {
        super(BlockType.FRAMED_ONE_WAY_WINDOW);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{PropertyHolder.NULLABLE_FACE});
    }

    @Override
    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        if (placer instanceof Player) {
            Player player = (Player)placer;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof FramedOwnableBlockEntity) {
                FramedOwnableBlockEntity be = (FramedOwnableBlockEntity)blockEntity;
                be.setOwner(player.m_142081_(), true);
            }
        }
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        if (player.m_21205_().m_150930_((Item)FBContent.itemFramedWrench.get()) && FramedOneWayWindowBlock.isOwnedBy((BlockGetter)level, pos, player)) {
            if (!level.m_5776_()) {
                if (player.m_6144_()) {
                    level.m_46597_(pos, (BlockState)state.m_61124_(PropertyHolder.NULLABLE_FACE, (Comparable)((Object)NullableDirection.NONE)));
                } else {
                    HitResult hit = player.m_19907_(10.0, 0.0f, false);
                    if (!(hit instanceof BlockHitResult)) {
                        return false;
                    }
                    BlockHitResult blockHit = (BlockHitResult)hit;
                    NullableDirection face = NullableDirection.fromDirection(blockHit.m_82434_());
                    level.m_46597_(pos, (BlockState)state.m_61124_(PropertyHolder.NULLABLE_FACE, (Comparable)((Object)face)));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        if (state.m_61143_(PropertyHolder.NULLABLE_FACE) != NullableDirection.NONE) {
            return Shapes.m_83040_();
        }
        return super.m_7952_(state, level, pos);
    }

    @Override
    public boolean shouldPreventNeighborCulling(BlockGetter level, BlockPos pos, BlockState state, BlockPos adjPos, BlockState adjState) {
        if (adjState.m_60734_() != FBContent.blockFramedOneWayWindow.get()) {
            return true;
        }
        return state.m_61143_(PropertyHolder.NULLABLE_FACE) != adjState.m_61143_(PropertyHolder.NULLABLE_FACE);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        Direction dir = ((NullableDirection)((Object)state.m_61143_(PropertyHolder.NULLABLE_FACE))).toDirection();
        if (dir != null && !Utils.isY(dir)) {
            dir = rotation.m_55954_(dir);
            state = (BlockState)state.m_61124_(PropertyHolder.NULLABLE_FACE, (Comparable)((Object)NullableDirection.fromDirection(dir)));
        }
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        Direction dir = ((NullableDirection)((Object)state.m_61143_(PropertyHolder.NULLABLE_FACE))).toDirection();
        if (dir != null && !Utils.isY(dir)) {
            dir = mirror.m_54848_(dir);
            state = (BlockState)state.m_61124_(PropertyHolder.NULLABLE_FACE, (Comparable)((Object)NullableDirection.fromDirection(dir)));
        }
        return state;
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedOwnableBlockEntity(pos, state);
    }

    public static boolean isOwnedBy(BlockGetter level, BlockPos pos, Player player) {
        if (!ServerConfig.oneWayWindowOwnable) {
            return true;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedOwnableBlockEntity) {
            FramedOwnableBlockEntity be = (FramedOwnableBlockEntity)blockEntity;
            return player.m_142081_().equals(be.getOwner());
        }
        return false;
    }
}

