/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.api.block.AbstractFramedBlock;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;
import xfacthd.framedblocks.common.data.property.SlopeType;

public class FramedBlock
extends AbstractFramedBlock {
    protected FramedBlock(BlockType blockType) {
        this(blockType, IFramedBlock.createProperties(blockType));
    }

    protected FramedBlock(BlockType blockType, BlockBehaviour.Properties props) {
        super(blockType, props);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        if (this.getBlockType() != BlockType.FRAMED_CUBE) {
            return false;
        }
        return super.m_7357_(state, level, pos, type);
    }

    protected static BlockState withSlopeType(BlockState state, Direction side, Direction facing, Vec3 hitVec) {
        state = (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing);
        Vec3 hitPoint = Utils.fraction(hitVec);
        if (!Utils.isY(side)) {
            if (hitPoint.m_7098_() < 0.1875) {
                side = Direction.UP;
            } else if (hitPoint.m_7098_() > 0.8125) {
                side = Direction.DOWN;
            }
        }
        if (side == Direction.DOWN) {
            state = (BlockState)state.m_61124_(PropertyHolder.SLOPE_TYPE, (Comparable)((Object)SlopeType.TOP));
        } else if (side == Direction.UP) {
            state = (BlockState)state.m_61124_(PropertyHolder.SLOPE_TYPE, (Comparable)((Object)SlopeType.BOTTOM));
        } else {
            state = (BlockState)state.m_61124_(PropertyHolder.SLOPE_TYPE, (Comparable)((Object)SlopeType.HORIZONTAL));
            state = FramedBlock.withCornerFacing(state, side, facing, hitVec);
        }
        return state;
    }

    protected static BlockState withCornerType(BlockState state, BlockPlaceContext context, Direction side, Direction typeSide, Vec3 hitPoint, Direction facing) {
        if (typeSide == Direction.DOWN) {
            state = (BlockState)state.m_61124_(PropertyHolder.CORNER_TYPE, (Comparable)((Object)CornerType.TOP));
            state = FramedBlock.withCornerFacing(state, side, facing, hitPoint);
        } else if (typeSide == Direction.UP) {
            state = (BlockState)state.m_61124_(PropertyHolder.CORNER_TYPE, (Comparable)((Object)CornerType.BOTTOM));
            state = FramedBlock.withCornerFacing(state, side, facing, hitPoint);
        } else {
            boolean xAxis = Utils.isX(context.m_43719_());
            boolean positive = Utils.isPositive(context.m_43719_().m_122428_());
            double xz = xAxis ? hitPoint.m_7094_() : hitPoint.m_7096_();
            double y = hitPoint.m_7098_();
            CornerType type = xz > 0.5 == positive ? (y > 0.5 ? CornerType.HORIZONTAL_TOP_RIGHT : CornerType.HORIZONTAL_BOTTOM_RIGHT) : (y > 0.5 ? CornerType.HORIZONTAL_TOP_LEFT : CornerType.HORIZONTAL_BOTTOM_LEFT);
            state = (BlockState)((BlockState)state.m_61124_(PropertyHolder.CORNER_TYPE, (Comparable)((Object)type))).m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing);
        }
        return state;
    }
}

