/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.blockentity.FramedSignBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;

public abstract class AbstractFramedSignBlock
extends FramedBlock {
    protected AbstractFramedSignBlock(BlockType type, BlockBehaviour.Properties props) {
        super(type, props);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean canInteract;
        InteractionResult result = super.m_6227_(state, level, pos, player, hand, hit);
        if (result != InteractionResult.PASS) {
            return result;
        }
        ItemStack stack = player.m_21120_(hand);
        boolean dye = stack.m_41720_() instanceof DyeItem;
        boolean glowInk = stack.m_150930_(Items.f_151056_);
        boolean inkSac = stack.m_150930_(Items.f_42532_);
        boolean bl = canInteract = (dye || glowInk || inkSac) && player.m_150110_().f_35938_;
        if (level.m_5776_()) {
            return canInteract ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedSignBlockEntity) {
            FramedSignBlockEntity sign = (FramedSignBlockEntity)blockEntity;
            if (canInteract) {
                boolean success = false;
                if (dye) {
                    level.m_5594_(null, pos, SoundEvents.f_144133_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    success = sign.setTextColor(((DyeItem)stack.m_41720_()).m_41089_());
                } else if (glowInk && !sign.hasGlowingText()) {
                    level.m_5594_(null, pos, SoundEvents.f_144153_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    success = sign.setGlowingText(true);
                    if (player instanceof ServerPlayer) {
                        CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, stack);
                    }
                } else if (inkSac && sign.hasGlowingText()) {
                    level.m_5594_(null, pos, SoundEvents.f_144181_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    success = sign.setGlowingText(false);
                }
                if (success) {
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                        player.m_150109_().m_6596_();
                    }
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                    return InteractionResult.SUCCESS;
                }
            } else if (sign.executeCommand((ServerPlayer)player)) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.tryApplyCamoImmediately(level, pos, placer, stack);
    }

    @Override
    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return type != PathComputationType.WATER || level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
    }

    @Override
    public final BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedSignBlockEntity(pos, state);
    }

    public boolean m_5568_() {
        return true;
    }
}

