/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.rail;

import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.client.model.slope.FramedSlopeModel;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.util.FramedUtils;

public class FramedRailSlopeModel
extends FramedSlopeModel {
    private final BlockState railState;
    private BakedModel railModel = null;

    private FramedRailSlopeModel(BlockState state, BakedModel baseModel, BlockState railBlock, EnumProperty<RailShape> shapeProperty) {
        super(FramedRailSlopeModel.getSlopeState(state), baseModel);
        RailShape shape = (RailShape)state.m_61143_(PropertyHolder.ASCENDING_RAIL_SHAPE);
        this.railState = (BlockState)railBlock.m_61124_(shapeProperty, (Comparable)shape);
    }

    @Override
    protected void getAdditionalQuads(Map<Direction, List<BakedQuad>> quadMap, BlockState state, Random rand, IModelData data, RenderType layer) {
        quadMap.get(null).addAll(this.getRailQuads(null, rand));
        for (Direction side : Direction.values()) {
            quadMap.get(side).addAll(this.getRailQuads(side, rand));
        }
    }

    @Override
    protected boolean hasAdditionalQuadsInLayer(RenderType layer) {
        return ItemBlockRenderTypes.canRenderInLayer((BlockState)this.railState, (RenderType)layer);
    }

    private List<BakedQuad> getRailQuads(@Nullable Direction side, Random rand) {
        if (this.railModel == null) {
            BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
            this.railModel = dispatcher.m_110910_(this.railState);
        }
        return this.railModel.getQuads(this.railState, side, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    private static BlockState getSlopeState(BlockState state) {
        RailShape shape = (RailShape)state.m_61143_(PropertyHolder.ASCENDING_RAIL_SHAPE);
        Direction dir = FramedUtils.getDirectionFromAscendingRailShape(shape);
        boolean ySlope = (Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE);
        return (BlockState)((BlockState)((Block)FBContent.blockFramedSlope.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir)).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope));
    }

    public static FramedRailSlopeModel normal(BlockState state, BakedModel baseModel) {
        return new FramedRailSlopeModel(state, baseModel, Blocks.f_50156_.m_49966_(), (EnumProperty<RailShape>)BlockStateProperties.f_61403_);
    }

    public static FramedRailSlopeModel powered(BlockState state, BakedModel baseModel) {
        boolean powered = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_);
        return new FramedRailSlopeModel(state, baseModel, (BlockState)Blocks.f_50030_.m_49966_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(powered)), (EnumProperty<RailShape>)BlockStateProperties.f_61404_);
    }

    public static FramedRailSlopeModel detector(BlockState state, BakedModel baseModel) {
        boolean powered = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_);
        return new FramedRailSlopeModel(state, baseModel, (BlockState)Blocks.f_50031_.m_49966_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(powered)), (EnumProperty<RailShape>)BlockStateProperties.f_61404_);
    }

    public static FramedRailSlopeModel activator(BlockState state, BakedModel baseModel) {
        boolean powered = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_);
        return new FramedRailSlopeModel(state, baseModel, (BlockState)Blocks.f_50285_.m_49966_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(powered)), (EnumProperty<RailShape>)BlockStateProperties.f_61404_);
    }

    public static BlockState itemSourceNormal() {
        return (BlockState)((Block)FBContent.blockFramedRailSlope.get()).m_49966_().m_61124_(PropertyHolder.ASCENDING_RAIL_SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
    }

    public static BlockState itemSourcePowered() {
        return (BlockState)((Block)FBContent.blockFramedPoweredRailSlope.get()).m_49966_().m_61124_(PropertyHolder.ASCENDING_RAIL_SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
    }

    public static BlockState itemSourceDetector() {
        return (BlockState)((Block)FBContent.blockFramedDetectorRailSlope.get()).m_49966_().m_61124_(PropertyHolder.ASCENDING_RAIL_SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
    }

    public static BlockState itemSourceActivator() {
        return (BlockState)((Block)FBContent.blockFramedActivatorRailSlope.get()).m_49966_().m_61124_(PropertyHolder.ASCENDING_RAIL_SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
    }
}

