/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.pane;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;

public class FramedPaneModel
extends FramedBlockModel {
    protected final boolean north;
    protected final boolean east;
    protected final boolean south;
    protected final boolean west;

    public FramedPaneModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.north = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61368_);
        this.east = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61369_);
        this.south = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61370_);
        this.west = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61371_);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction face = quad.m_111306_();
        if (Utils.isY(face)) {
            FramedPaneModel.createTopBottomCenterQuad(quadMap, quad, false);
            if (this.north) {
                FramedPaneModel.createTopBottomEdgeQuad(quadMap, quad, Direction.NORTH, false);
            }
            if (this.east) {
                FramedPaneModel.createTopBottomEdgeQuad(quadMap, quad, Direction.EAST, false);
            }
            if (this.south) {
                FramedPaneModel.createTopBottomEdgeQuad(quadMap, quad, Direction.SOUTH, false);
            }
            if (this.west) {
                FramedPaneModel.createTopBottomEdgeQuad(quadMap, quad, Direction.WEST, false);
            }
        } else {
            FramedPaneModel.createSideEdgeQuad(quadMap, quad, this.isSideInset(face), false);
            if (Utils.isX(face)) {
                if (this.north) {
                    FramedPaneModel.createSideQuad(quadMap.get(null), quad, Direction.NORTH);
                }
                if (this.south) {
                    FramedPaneModel.createSideQuad(quadMap.get(null), quad, Direction.SOUTH);
                }
            }
            if (Utils.isZ(face)) {
                if (this.east) {
                    FramedPaneModel.createSideQuad(quadMap.get(null), quad, Direction.EAST);
                }
                if (this.west) {
                    FramedPaneModel.createSideQuad(quadMap.get(null), quad, Direction.WEST);
                }
            }
        }
    }

    protected static void createTopBottomCenterQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, boolean mirrored) {
        QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(0.4375f, 0.4375f, 0.5625f, 0.5625f)).applyIf(Modifiers.setPosition(0.001f), mirrored).export(quadMap.get(mirrored ? null : quad.m_111306_()));
    }

    protected static void createTopBottomEdgeQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, Direction dir, boolean mirrored) {
        Preconditions.checkArgument((!Utils.isY(dir) ? 1 : 0) != 0, (Object)String.format("Invalid direction: %s!", dir));
        QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(dir.m_122424_(), 0.4375f)).apply(Modifiers.cutTopBottom(dir.m_122427_().m_122434_(), 0.5625f)).applyIf(Modifiers.setPosition(0.001f), mirrored).export(quadMap.get(mirrored ? null : quad.m_111306_()));
    }

    protected static void createSideEdgeQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, boolean inset, boolean mirrored) {
        if (inset && mirrored) {
            throw new IllegalArgumentException("Quad can't be mirrored and inset!");
        }
        Direction quadDir = quad.m_111306_();
        Direction exportSide = inset ? null : (mirrored ? quadDir.m_122424_() : quadDir);
        QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(0.5625f)).applyIf(Modifiers.setPosition(0.5625f), inset).applyIf(Modifiers.setPosition(0.001f), !inset && mirrored).export(quadMap.get(exportSide));
    }

    private static void createSideQuad(List<BakedQuad> quadList, BakedQuad quad, Direction dir) {
        QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(dir.m_122424_(), 0.4375f)).apply(Modifiers.setPosition(0.5625f)).export(quadList);
    }

    protected boolean isSideInset(Direction face) {
        return switch (face) {
            case Direction.NORTH -> {
                if (!this.north) {
                    yield true;
                }
                yield false;
            }
            case Direction.EAST -> {
                if (!this.east) {
                    yield true;
                }
                yield false;
            }
            case Direction.SOUTH -> {
                if (!this.south) {
                    yield true;
                }
                yield false;
            }
            case Direction.WEST -> {
                if (!this.west) {
                    yield true;
                }
                yield false;
            }
            default -> throw new IllegalArgumentException(String.format("Invalid face: %s!", face));
        };
    }
}

