/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.loader.overlay;

import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;

class OverlayModel
extends BakedModelWrapper<BakedModel> {
    private final List<BakedQuad> unculledQuads;
    private final Map<Direction, List<BakedQuad>> culledQuads;

    public OverlayModel(BakedModel model, Vector3f offset, Vector3f scale) {
        super(model);
        Random random = new Random();
        this.unculledQuads = OverlayModel.makeUnculledQuads(model, offset, scale, random);
        this.culledQuads = OverlayModel.makeCulledQuads(model, offset, scale, random);
    }

    public List<BakedQuad> m_6840_(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        return side == null ? this.unculledQuads : this.culledQuads.get(side);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull Random rand, @NotNull IModelData extraData) {
        return side == null ? this.unculledQuads : this.culledQuads.get(side);
    }

    private static List<BakedQuad> makeUnculledQuads(BakedModel model, Vector3f offset, Vector3f scale, Random random) {
        return OverlayModel.untranslateQuads(model.getQuads(null, null, random, (IModelData)EmptyModelData.INSTANCE), offset, scale);
    }

    private static Map<Direction, List<BakedQuad>> makeCulledQuads(BakedModel model, Vector3f offset, Vector3f scale, Random random) {
        EnumMap<Direction, List<BakedQuad>> quadMap = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
        for (Direction side : Direction.values()) {
            List quads = model.getQuads(null, side, random, (IModelData)EmptyModelData.INSTANCE);
            quadMap.put(side, OverlayModel.untranslateQuads(quads, offset, scale));
        }
        return quadMap;
    }

    private static List<BakedQuad> untranslateQuads(List<BakedQuad> quads, Vector3f offset, Vector3f scale) {
        ArrayList<BakedQuad> newQuads = new ArrayList<BakedQuad>(quads.size());
        for (BakedQuad quad : quads) {
            QuadModifier.geometry(quad).apply(Modifiers.offset(Direction.WEST, offset.m_122239_() * (1.0f / scale.m_122239_()))).apply(Modifiers.offset(Direction.DOWN, offset.m_122260_() * (1.0f / scale.m_122260_()))).apply(Modifiers.offset(Direction.NORTH, offset.m_122269_() * (1.0f / scale.m_122269_()))).export(newQuads);
        }
        return newQuads;
    }
}

