/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.fluids;

import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.common.IPRegisters;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class IPFluid
extends FlowingFluid {
    public static final List<IPFluidEntry> FLUIDS = new ArrayList<IPFluidEntry>();
    protected final IPFluidEntry entry;
    protected final ResourceLocation stillTexture;
    protected final ResourceLocation flowingTexture;
    @Nullable
    protected final Consumer<FluidAttributes.Builder> buildAttributes;

    public IPFluid(IPFluidEntry entry, int density, int viscosity, boolean isGas) {
        this(entry, builder -> {
            builder.viscosity(viscosity).density(density);
            if (isGas) {
                builder.gaseous();
            }
        });
    }

    protected IPFluid(IPFluidEntry entry, Consumer<FluidAttributes.Builder> attributeBuilder) {
        this(entry, ResourceUtils.ip("block/fluid/" + entry.name + "_still"), ResourceUtils.ip("block/fluid/" + entry.name + "_flow"), attributeBuilder);
    }

    protected IPFluid(IPFluidEntry entry, ResourceLocation stillTexture, ResourceLocation flowingTexture, @Nullable Consumer<FluidAttributes.Builder> buildAttributes) {
        this(entry, stillTexture, flowingTexture, buildAttributes, true);
    }

    protected IPFluid(IPFluidEntry entry, ResourceLocation stillTexture, ResourceLocation flowingTexture, @Nullable Consumer<FluidAttributes.Builder> buildAttributes, boolean isSource) {
        this.entry = entry;
        this.stillTexture = stillTexture;
        this.flowingTexture = flowingTexture;
        this.buildAttributes = buildAttributes;
    }

    public static IPFluidEntry makeFluid(String name, Function<IPFluidEntry, IPFluid> factory) {
        return IPFluid.makeFluid(name, factory, IPFluidBlock::new);
    }

    public static IPFluidEntry makeFluid(String name, Function<IPFluidEntry, IPFluid> factory, Function<IPFluidEntry, Block> blockFactory) {
        MutableObject entry = new MutableObject();
        entry.setValue((Object)new IPFluidEntry(name, IPRegisters.registerFluid(name, () -> IPFluid.lambda$makeFluid$1(factory, (Mutable)entry)), IPRegisters.registerFluid(name + "_flowing", () -> IPFluid.lambda$makeFluid$2((Mutable)entry)), IPRegisters.registerBlock(name, () -> IPFluid.lambda$makeFluid$3(blockFactory, (Mutable)entry)), IPRegisters.registerItem(name + "_bucket", () -> IPFluid.lambda$makeFluid$4((Mutable)entry))));
        FLUIDS.add((IPFluidEntry)entry.getValue());
        return (IPFluidEntry)entry.getValue();
    }

    @Nonnull
    protected FluidAttributes createAttributes() {
        FluidAttributes.Builder builder = FluidAttributes.builder((ResourceLocation)this.stillTexture, (ResourceLocation)this.flowingTexture).overlay(this.stillTexture).sound(SoundEvents.f_11781_, SoundEvents.f_11778_);
        if (this.buildAttributes != null) {
            this.buildAttributes.accept(builder);
        }
        return builder.build((Fluid)this);
    }

    protected void m_7456_(@Nonnull LevelAccessor arg0, @Nonnull BlockPos arg1, @Nonnull BlockState arg2) {
    }

    protected boolean m_6760_() {
        return false;
    }

    @Nonnull
    public Fluid m_5615_() {
        return (Fluid)this.entry.flowing.get();
    }

    @Nonnull
    public Fluid m_5613_() {
        return (Fluid)this.entry.still.get();
    }

    @Nonnull
    public Item m_6859_() {
        return (Item)this.entry.bucket.get();
    }

    protected int m_6713_(@Nonnull LevelReader arg0) {
        return 1;
    }

    protected int m_6719_(@Nonnull LevelReader arg0) {
        return 4;
    }

    protected boolean m_5486_(@Nonnull FluidState p_215665_1_, @Nonnull BlockGetter p_215665_2_, @Nonnull BlockPos p_215665_3_, @Nonnull Fluid p_215665_4_, @Nonnull Direction p_215665_5_) {
        return p_215665_5_ == Direction.DOWN && !this.m_6212_(p_215665_4_);
    }

    public int m_6718_(@Nonnull LevelReader p_205569_1_) {
        return 5;
    }

    protected float m_6752_() {
        return 100.0f;
    }

    @Nonnull
    protected BlockState m_5804_(@Nonnull FluidState state) {
        return (BlockState)((Block)this.entry.block.get()).m_49966_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(IPFluid.m_76092_((FluidState)state)));
    }

    public boolean m_7444_(FluidState state) {
        return state.m_192917_(this.m_5613_());
    }

    public int m_7430_(@Nonnull FluidState state) {
        return this.m_7444_(state) ? 8 : (Integer)state.m_61143_((Property)f_75948_);
    }

    public boolean m_6212_(Fluid fluidIn) {
        return fluidIn.equals(this.m_5613_()) || fluidIn.equals(this.m_5615_());
    }

    private static /* synthetic */ Item lambda$makeFluid$4(Mutable entry) {
        return new IPBucketItem((Supplier<? extends Fluid>)((IPFluidEntry)entry.getValue()).still());
    }

    private static /* synthetic */ Block lambda$makeFluid$3(Function blockFactory, Mutable entry) {
        return (Block)blockFactory.apply((IPFluidEntry)entry.getValue());
    }

    private static /* synthetic */ IPFluid lambda$makeFluid$2(Mutable entry) {
        return new IPFluidFlowing((IPFluid)((Object)((IPFluidEntry)entry.getValue()).still.get()));
    }

    private static /* synthetic */ IPFluid lambda$makeFluid$1(Function factory, Mutable entry) {
        return (IPFluid)((Object)factory.apply((IPFluidEntry)entry.getValue()));
    }

    public record IPFluidEntry(String name, RegistryObject<IPFluid> still, RegistryObject<IPFluid> flowing, RegistryObject<Block> block, RegistryObject<Item> bucket) {
        public Fluid get() {
            return (Fluid)this.still().get();
        }
    }

    public static class IPBucketItem
    extends BucketItem {
        private static final Item.Properties PROPS = new Item.Properties().m_41487_(1).m_41491_(ImmersivePetroleum.creativeTab);

        public IPBucketItem(Supplier<? extends Fluid> fluid) {
            super(fluid, PROPS);
        }

        public ItemStack getContainerItem(ItemStack itemStack) {
            return new ItemStack((ItemLike)Items.f_42446_);
        }

        public boolean hasContainerItem(ItemStack stack) {
            return true;
        }

        public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable CompoundTag nbt) {
            return new FluidBucketWrapper(stack);
        }
    }

    public static class IPFluidFlowing
    extends IPFluid {
        public IPFluidFlowing(IPFluid source) {
            super(source.entry, source.stillTexture, source.flowingTexture, source.buildAttributes, false);
            this.m_76142_((FluidState)((FluidState)this.m_76144_().m_61090_()).m_61124_((Property)f_75948_, (Comparable)Integer.valueOf(7)));
        }

        protected void m_7180_(@Nonnull StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{f_75948_});
        }
    }

    public static class IPFluidBlock
    extends LiquidBlock {
        public IPFluidBlock(IPFluidEntry entry) {
            super(entry.still(), BlockBehaviour.Properties.m_60939_((Material)Material.f_76305_));
        }
    }
}

