/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.render;

import blusunrize.immersiveengineering.client.utils.GuiHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import flaxbeard.immersivepetroleum.api.crafting.LubricatedHandler;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.AutoLubricatorTileEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

public class AutoLubricatorRenderer
implements BlockEntityRenderer<AutoLubricatorTileEntity> {
    public boolean shouldRenderOffScreen(@Nonnull AutoLubricatorTileEntity te) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(@Nonnull AutoLubricatorTileEntity te, float partialTicks, @Nonnull PoseStack transform, @Nonnull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockEntity master;
        if (te.isSlave) {
            return;
        }
        FluidStack fs = te.tank.getFluid();
        float level = 0.0f;
        if (!fs.isEmpty()) {
            level = (float)fs.getAmount() / (float)te.tank.getCapacity();
        }
        if (level > 0.0f) {
            float height = 16.0f;
            transform.m_85836_();
            float scale = 0.0625f;
            transform.m_85837_(0.25, 0.875, 0.25);
            transform.m_85841_(scale, scale, scale);
            VertexConsumer builder = bufferIn.m_6299_(RenderType.m_110451_());
            float h = height * level;
            GuiHelper.drawRepeatedFluidSprite((VertexConsumer)builder, (PoseStack)transform, (FluidStack)fs, (float)0.0f, (float)0.0f, (float)8.0f, (float)h);
            transform.m_85845_(new Quaternion(0.0f, 90.0f, 0.0f, true));
            transform.m_85837_(-7.98, 0.0, 0.0);
            GuiHelper.drawRepeatedFluidSprite((VertexConsumer)builder, (PoseStack)transform, (FluidStack)fs, (float)0.0f, (float)0.0f, (float)8.0f, (float)h);
            transform.m_85845_(new Quaternion(0.0f, 90.0f, 0.0f, true));
            transform.m_85837_(-7.98, 0.0, 0.0);
            GuiHelper.drawRepeatedFluidSprite((VertexConsumer)builder, (PoseStack)transform, (FluidStack)fs, (float)0.0f, (float)0.0f, (float)8.0f, (float)h);
            transform.m_85845_(new Quaternion(0.0f, 90.0f, 0.0f, true));
            transform.m_85837_(-7.98, 0.0, 0.0);
            GuiHelper.drawRepeatedFluidSprite((VertexConsumer)builder, (PoseStack)transform, (FluidStack)fs, (float)0.0f, (float)0.0f, (float)8.0f, (float)h);
            if (h < height) {
                transform.m_85845_(new Quaternion(90.0f, 0.0f, 0.0f, true));
                transform.m_85837_(0.0, 0.0, (double)(-h));
                GuiHelper.drawRepeatedFluidSprite((VertexConsumer)builder, (PoseStack)transform, (FluidStack)fs, (float)0.0f, (float)0.0f, (float)8.0f, (float)8.0f);
            }
            transform.m_85849_();
        }
        transform.m_85836_();
        BlockPos target = te.m_58899_().m_142300_(te.getFacing());
        BlockEntity test = te.m_58904_().m_7702_(target);
        LubricatedHandler.ILubricationHandler<BlockEntity> handler = LubricatedHandler.getHandlerForTile(test);
        if (handler != null && (master = handler.isPlacedCorrectly(te.m_58904_(), te, te.getFacing())) != null) {
            handler.renderPipes(te, master, transform, bufferIn, combinedLightIn, combinedOverlayIn);
        }
        transform.m_85849_();
    }
}

