/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.reservoir;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirIsland;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirType;
import flaxbeard.immersivepetroleum.common.ReservoirRegionDataStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import org.apache.commons.lang3.tuple.Pair;

public class ReservoirHandler {
    @Deprecated(forRemoval=true)
    private static final Multimap<ResourceKey<Level>, ReservoirIsland> RESERVOIR_ISLAND_LIST = ArrayListMultimap.create();
    private static final Map<Pair<ResourceKey<Level>, ColumnPos>, ReservoirIsland> CACHE = new HashMap<Pair<ResourceKey<Level>, ColumnPos>, ReservoirIsland>();
    private static Map<ResourceLocation, Map<ResourceLocation, Integer>> totalWeightMap = new HashMap<ResourceLocation, Map<ResourceLocation, Integer>>();
    private static long lastSeed;
    private static PerlinSimplexNoise generator;
    static final double scale = 0.015625;
    static final double d0 = 0.6666666666666666;
    static final double d1 = 0.3333333333333333;

    public static void scanChunkForNewReservoirs(ServerLevel world, ChunkPos chunkPos, Random random) {
        int chunkX = chunkPos.m_45604_();
        int chunkZ = chunkPos.m_45605_();
        ResourceKey dimensionKey = world.m_46472_();
        ResourceLocation dimensionRL = dimensionKey.m_135782_();
        ReservoirRegionDataStorage storage = ReservoirRegionDataStorage.get();
        for (int j = 0; j < 16; ++j) {
            for (int i = 0; i < 16; ++i) {
                int x = chunkX + i;
                int z = chunkZ + j;
                if (!(ReservoirHandler.getValueOf((Level)world, x, z) > -1.0)) continue;
                ResourceLocation biomeRL = ((Biome)world.m_204166_(new BlockPos(x, 64, z)).m_203334_()).getRegistryName();
                ColumnPos current = new ColumnPos(x, z);
                if (storage.existsAt(current)) {
                    return;
                }
                ReservoirType reservoir = null;
                int totalWeight = ReservoirHandler.getTotalWeight(dimensionRL, biomeRL);
                if (totalWeight <= 0) continue;
                int weight = Math.abs(random.nextInt() % totalWeight);
                for (ReservoirType res : ReservoirType.map.values()) {
                    if (!res.getDimensions().valid(dimensionRL) || !res.getBiomes().valid(biomeRL) || (weight -= res.weight) >= 0) continue;
                    reservoir = res;
                    break;
                }
                if (reservoir == null) continue;
                HashSet<ColumnPos> pol = new HashSet<ColumnPos>();
                ReservoirHandler.next((Level)world, pol, x, z);
                List<ColumnPos> poly = ReservoirHandler.optimizeIsland((Level)world, new ArrayList<ColumnPos>(pol));
                if (poly.isEmpty()) continue;
                int amount = (int)Mth.m_14179_((float)random.nextFloat(), (float)reservoir.minSize, (float)reservoir.maxSize);
                ReservoirIsland island = new ReservoirIsland(poly, reservoir, amount);
                storage.addIsland((ResourceKey<Level>)dimensionKey, island);
            }
        }
    }

    public static int getTotalWeight(ResourceLocation dimension, ResourceLocation biome) {
        Map map = totalWeightMap.computeIfAbsent(dimension, k -> new HashMap());
        Integer totalWeight = (Integer)map.get(biome);
        if (totalWeight == null) {
            totalWeight = 0;
            for (ReservoirType reservoir : ReservoirType.map.values()) {
                if (!reservoir.getDimensions().valid(dimension) || !reservoir.getBiomes().valid(biome)) continue;
                totalWeight = totalWeight + reservoir.weight;
            }
            map.put(biome, totalWeight);
        }
        return totalWeight;
    }

    public static ReservoirIsland getIsland(Level world, BlockPos pos) {
        return ReservoirHandler.getIsland(world, new ColumnPos(pos));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReservoirIsland getIsland(Level world, ColumnPos pos) {
        if (world.f_46443_) {
            return null;
        }
        ResourceKey dimension = world.m_46472_();
        Pair cacheKey = Pair.of((Object)dimension, (Object)pos);
        Map<Pair<ResourceKey<Level>, ColumnPos>, ReservoirIsland> map = CACHE;
        synchronized (map) {
            ReservoirIsland ret = CACHE.get(cacheKey);
            if (ret == null) {
                ReservoirIsland island = ReservoirRegionDataStorage.get().getIsland(world, pos);
                CACHE.put((Pair<ResourceKey<Level>, ColumnPos>)cacheKey, island);
                return island;
            }
            return ret;
        }
    }

    public static ReservoirIsland getIslandNoCache(Level world, BlockPos pos) {
        return ReservoirHandler.getIslandNoCache(world, new ColumnPos(pos));
    }

    public static ReservoirIsland getIslandNoCache(Level world, ColumnPos pos) {
        if (world.f_46443_) {
            return null;
        }
        ReservoirIsland island = ReservoirRegionDataStorage.get().getIsland(world, pos);
        return island;
    }

    public static ReservoirType addReservoir(ResourceLocation id, ReservoirType reservoir) {
        ReservoirType.map.put(id, reservoir);
        return reservoir;
    }

    public static double getValueOf(@Nonnull Level level, int x, int z) {
        double noise;
        if (!level.f_46443_ && level instanceof WorldGenLevel) {
            WorldGenLevel worldGen = (WorldGenLevel)level;
            ReservoirHandler.initGenerator(worldGen);
        }
        if ((noise = Math.abs(generator.m_75449_((double)x * 0.015625, (double)z * 0.015625, false))) > 0.6666666666666666) {
            return (noise - 0.6666666666666666) / 0.3333333333333333;
        }
        return -1.0;
    }

    public static void initGenerator(WorldGenLevel world) {
        if (generator == null || world.m_7328_() != lastSeed) {
            lastSeed = world.m_7328_();
            generator = new PerlinSimplexNoise((RandomSource)new WorldgenRandom((RandomSource)new SingleThreadedRandomSource(lastSeed)), (List)ImmutableList.of((Object)0));
        }
    }

    public static PerlinSimplexNoise getGenerator() {
        return generator;
    }

    static void next(Level world, Set<ColumnPos> list, int x, int z) {
        if (ReservoirHandler.getValueOf(world, x, z) > -1.0 && !list.contains(new ColumnPos(x, z))) {
            list.add(new ColumnPos(x, z));
            ReservoirHandler.next(world, list, x + 1, z);
            ReservoirHandler.next(world, list, x - 1, z);
            ReservoirHandler.next(world, list, x, z + 1);
            ReservoirHandler.next(world, list, x, z - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Map<Pair<ResourceKey<Level>, ColumnPos>, ReservoirIsland> map = CACHE;
        synchronized (map) {
            CACHE.clear();
        }
    }

    public static void recalculateChances() {
        totalWeightMap.clear();
    }

    @Deprecated(forRemoval=true)
    public static Multimap<ResourceKey<Level>, ReservoirIsland> getReservoirIslandList() {
        return RESERVOIR_ISLAND_LIST;
    }

    private static List<ColumnPos> optimizeIsland(Level world, List<ColumnPos> poly) {
        poly = ReservoirHandler.keepOutline(world, poly);
        poly = ReservoirHandler.makeDirectional(poly);
        poly = ReservoirHandler.cullLines(poly);
        return poly;
    }

    private static List<ColumnPos> keepOutline(Level world, List<ColumnPos> poly) {
        HashSet set = new HashSet();
        poly.forEach(pos -> {
            for (int z = -1; z <= 1; ++z) {
                for (int x = -1; x <= 1; ++x) {
                    ColumnPos p;
                    if (ReservoirHandler.getValueOf(world, pos.f_140723_ + 1, pos.f_140724_) == -1.0) {
                        p = new ColumnPos(pos.f_140723_ + 1, pos.f_140724_);
                        set.add(p);
                    }
                    if (ReservoirHandler.getValueOf(world, pos.f_140723_ - 1, pos.f_140724_) == -1.0) {
                        p = new ColumnPos(pos.f_140723_ - 1, pos.f_140724_);
                        set.add(p);
                    }
                    if (ReservoirHandler.getValueOf(world, pos.f_140723_, pos.f_140724_ + 1) == -1.0) {
                        p = new ColumnPos(pos.f_140723_, pos.f_140724_ + 1);
                        set.add(p);
                    }
                    if (ReservoirHandler.getValueOf(world, pos.f_140723_, pos.f_140724_ - 1) != -1.0) continue;
                    p = new ColumnPos(pos.f_140723_, pos.f_140724_ - 1);
                    set.add(p);
                }
            }
        });
        return new ArrayList<ColumnPos>(set);
    }

    private static List<ColumnPos> makeDirectional(List<ColumnPos> poly) {
        ArrayList<ColumnPos> list = new ArrayList<ColumnPos>();
        list.add(poly.remove(0));
        int a = 0;
        while (poly.size() > 0) {
            ColumnPos col = (ColumnPos)list.get(a);
            if (ReservoirHandler.moveNext(col, poly, list)) {
                ++a;
                continue;
            }
            ImmersivePetroleum.log.warn("This should not happen, but it did..");
            break;
        }
        return list;
    }

    private static ArrayList<ColumnPos> cullLines(List<ColumnPos> poly) {
        ArrayList<ColumnPos> list = new ArrayList<ColumnPos>(poly);
        int endIndex = 0;
        ColumnPos startPos = null;
        ColumnPos endPos = null;
        for (int startIndex = 0; startIndex < list.size(); ++startIndex) {
            boolean debug;
            ColumnPos pos;
            int index;
            int j;
            startPos = list.get(startIndex);
            for (j = 1; j < 64; ++j) {
                index = (startIndex + j) % list.size();
                pos = list.get(index);
                if (startPos.f_140724_ != pos.f_140724_) break;
                endIndex = index;
                endPos = pos;
            }
            for (j = 1; j < 64; ++j) {
                index = (startIndex + j) % list.size();
                pos = list.get(index);
                if (startPos.f_140723_ != pos.f_140723_) break;
                endIndex = index;
                endPos = pos;
            }
            if (debug = false) {
                for (int j2 = 1; j2 < 64; ++j2) {
                    int dz;
                    int index2 = (startIndex + j2) % list.size();
                    ColumnPos pos2 = list.get(index2);
                    int dx = Math.abs(pos2.f_140723_ - startPos.f_140723_);
                    if (dx != (dz = Math.abs(pos2.f_140724_ - startPos.f_140724_))) break;
                    endIndex = index2;
                    endPos = pos2;
                }
            }
            if (startPos == null || endPos == null) continue;
            int len = endIndex - startIndex;
            if (len > 1) {
                int index3;
                for (int j3 = index3 = startIndex + 1; j3 < endIndex; ++j3) {
                    list.remove(index3 % list.size());
                }
            } else if (len < 0 && (len = len + list.size() - 1) > 1) {
                int index4 = startIndex + 1;
                for (int j4 = 0; j4 < len; ++j4) {
                    list.remove(index4 % list.size());
                }
            }
            endPos = null;
            startPos = null;
        }
        return list;
    }

    private static boolean moveNext(ColumnPos pos, List<ColumnPos> src, List<ColumnPos> dst) {
        ColumnPos p0 = new ColumnPos(pos.f_140723_ + 1, pos.f_140724_);
        ColumnPos p1 = new ColumnPos(pos.f_140723_ - 1, pos.f_140724_);
        ColumnPos p2 = new ColumnPos(pos.f_140723_, pos.f_140724_ + 1);
        ColumnPos p3 = new ColumnPos(pos.f_140723_, pos.f_140724_ - 1);
        if (src.remove(p0) && dst.add(p0) || src.remove(p1) && dst.add(p1) || src.remove(p2) && dst.add(p2) || src.remove(p3) && dst.add(p3)) {
            return true;
        }
        ColumnPos p4 = new ColumnPos(pos.f_140723_ - 1, pos.f_140724_ - 1);
        ColumnPos p5 = new ColumnPos(pos.f_140723_ - 1, pos.f_140724_ + 1);
        ColumnPos p6 = new ColumnPos(pos.f_140723_ + 1, pos.f_140724_ - 1);
        ColumnPos p7 = new ColumnPos(pos.f_140723_ + 1, pos.f_140724_ + 1);
        return src.remove(p4) && dst.add(p4) || src.remove(p5) && dst.add(p5) || src.remove(p6) && dst.add(p6) || src.remove(p7) && dst.add(p7);
    }
}

