/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.crafting;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import flaxbeard.immersivepetroleum.api.crafting.IPMultiblockRecipe;
import flaxbeard.immersivepetroleum.api.crafting.IPRecipeTypes;
import flaxbeard.immersivepetroleum.common.cfg.IPServerConfig;
import flaxbeard.immersivepetroleum.common.crafting.Serializers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;

public class CokerUnitRecipe
extends IPMultiblockRecipe {
    public static Map<ResourceLocation, CokerUnitRecipe> recipes = new HashMap<ResourceLocation, CokerUnitRecipe>();
    public final Lazy<ItemStack> outputItem;
    public final FluidStack outputFluid;
    public final IngredientWithSize inputItem;
    public final FluidTagInput inputFluid;

    public static CokerUnitRecipe findRecipe(ItemStack stack, FluidStack fluid) {
        for (CokerUnitRecipe recipe : recipes.values()) {
            if (recipe.inputItem == null || !recipe.inputItem.test(stack) || recipe.inputFluid == null || !recipe.inputFluid.test(fluid)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean hasRecipeWithInput(@Nonnull ItemStack stack, @Nonnull FluidStack fluid) {
        Objects.requireNonNull(stack);
        Objects.requireNonNull(fluid);
        if (!stack.m_41619_() && !fluid.isEmpty()) {
            for (CokerUnitRecipe recipe : recipes.values()) {
                if (recipe.inputItem == null || recipe.inputFluid == null || !recipe.inputItem.test(stack) || !recipe.inputFluid.test(fluid)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasRecipeWithInput(@Nonnull ItemStack stack, boolean ignoreSize) {
        Objects.requireNonNull(stack);
        if (!stack.m_41619_()) {
            for (CokerUnitRecipe recipe : recipes.values()) {
                if (recipe.inputItem == null || (ignoreSize || !recipe.inputItem.test(stack)) && (!ignoreSize || !recipe.inputItem.testIgnoringSize(stack))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasRecipeWithInput(@Nonnull FluidStack fluid, boolean ignoreAmount) {
        Objects.requireNonNull(fluid);
        if (!fluid.isEmpty()) {
            for (CokerUnitRecipe recipe : recipes.values()) {
                if (recipe.inputFluid == null || (ignoreAmount || !recipe.inputFluid.test(fluid)) && (!ignoreAmount || !recipe.inputFluid.testIgnoringAmount(fluid))) continue;
                return true;
            }
        }
        return false;
    }

    public CokerUnitRecipe(ResourceLocation id, Lazy<ItemStack> outputItem2, FluidStack outputFluid, IngredientWithSize inputItem, FluidTagInput inputFluid, int energy, int time) {
        super(ItemStack.f_41583_, (Supplier<? extends RecipeType<?>>)IPRecipeTypes.COKER, id);
        this.inputFluid = inputFluid;
        this.inputItem = inputItem;
        this.outputFluid = outputFluid;
        this.outputItem = outputItem2;
        this.timeAndEnergy(time, energy);
        this.modifyTimeAndEnergy(() -> IPServerConfig.REFINING.cokerUnit_timeModifier.get(), () -> IPServerConfig.REFINING.cokerUnit_energyModifier.get());
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    public NonNullList<ItemStack> getActualItemOutputs(BlockEntity tile) {
        NonNullList list = NonNullList.m_122779_();
        list.add((Object)((ItemStack)this.outputItem.get()));
        return list;
    }

    protected IERecipeSerializer<CokerUnitRecipe> getIESerializer() {
        return (IERecipeSerializer)Serializers.COKER_SERIALIZER.get();
    }
}

