/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api;

import com.google.common.base.Preconditions;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class IPTags {
    private static final Map<TagKey<Block>, TagKey<Item>> toItemTag = new HashMap<TagKey<Block>, TagKey<Item>>();

    public static TagKey<Item> getItemTag(TagKey<Block> blockTag) {
        Preconditions.checkArgument((boolean)toItemTag.containsKey(blockTag));
        return toItemTag.get(blockTag);
    }

    private static TagKey<Block> createBlockTag(ResourceLocation name) {
        TagKey<Block> blockTag = IPTags.createBlockWrapper(name);
        toItemTag.put(blockTag, IPTags.createItemWrapper(name));
        return blockTag;
    }

    public static void forAllBlocktags(BiConsumer<TagKey<Block>, TagKey<Item>> out) {
        for (Map.Entry<TagKey<Block>, TagKey<Item>> entry : toItemTag.entrySet()) {
            out.accept(entry.getKey(), entry.getValue());
        }
    }

    private static TagKey<Block> createBlockWrapper(ResourceLocation name) {
        return BlockTags.create((ResourceLocation)name);
    }

    private static TagKey<Item> createItemWrapper(ResourceLocation name) {
        return ItemTags.create((ResourceLocation)name);
    }

    private static TagKey<Fluid> createFluidWrapper(ResourceLocation name) {
        return FluidTags.create((ResourceLocation)name);
    }

    public static class Utility {
        public static final TagKey<Fluid> burnableInFlarestack = IPTags.createFluidWrapper(ResourceUtils.ip("burnable_in_flarestack"));
        public static final TagKey<Item> toolboxTools = IPTags.createItemWrapper(ResourceUtils.ie("toolbox/tools"));
    }

    public static class Fluids {
        public static final TagKey<Fluid> crudeOil = IPTags.createFluidWrapper(ResourceUtils.forge("crude_oil"));
        public static final TagKey<Fluid> diesel = IPTags.createFluidWrapper(ResourceUtils.forge("diesel"));
        public static final TagKey<Fluid> diesel_sulfur = IPTags.createFluidWrapper(ResourceUtils.forge("diesel_sulfur"));
        public static final TagKey<Fluid> gasoline = IPTags.createFluidWrapper(ResourceUtils.forge("gasoline"));
        public static final TagKey<Fluid> lubricant = IPTags.createFluidWrapper(ResourceUtils.forge("lubricant"));
        public static final TagKey<Fluid> napalm = IPTags.createFluidWrapper(ResourceUtils.forge("napalm"));
        public static final TagKey<Fluid> naphtha = IPTags.createFluidWrapper(ResourceUtils.forge("naphtha"));
        public static final TagKey<Fluid> naphtha_cracked = IPTags.createFluidWrapper(ResourceUtils.forge("naphtha_cracked"));
        public static final TagKey<Fluid> benzene = IPTags.createFluidWrapper(ResourceUtils.forge("benzene"));
        public static final TagKey<Fluid> propylene = IPTags.createFluidWrapper(ResourceUtils.forge("propylene"));
        public static final TagKey<Fluid> ethylene = IPTags.createFluidWrapper(ResourceUtils.forge("ethylene"));
        public static final TagKey<Fluid> lubricant_cracked = IPTags.createFluidWrapper(ResourceUtils.forge("lubricant_cracked"));
        public static final TagKey<Fluid> kerosene = IPTags.createFluidWrapper(ResourceUtils.forge("kerosene"));
        public static final TagKey<Fluid> gasoline_additives = IPTags.createFluidWrapper(ResourceUtils.forge("gasoline_additives"));
    }

    public static class Items {
        public static final TagKey<Item> bitumen = IPTags.createItemWrapper(ResourceUtils.forge("bitumen"));
        public static final TagKey<Item> petcoke = IPTags.createItemWrapper(ResourceUtils.forge("coal_petcoke"));
        public static final TagKey<Item> petcokeDust = IPTags.createItemWrapper(ResourceUtils.forge("dusts/coal_petcoke"));
        public static final TagKey<Item> petcokeStorage = IPTags.createItemWrapper(ResourceUtils.forge("storage_blocks/coal_petcoke"));
        public static final TagKey<Item> paraffinWax = IPTags.createItemWrapper(ResourceUtils.forge("wax/paraffin"));
        public static final TagKey<Item> wax = IPTags.createItemWrapper(ResourceUtils.forge("wax"));
        public static final TagKey<Item> waxBlock = IPTags.createItemWrapper(ResourceUtils.forge("storage_blocks/wax"));
        public static final TagKey<Item> paraffinWaxBlock = IPTags.createItemWrapper(ResourceUtils.forge("storage_blocks/wax/paraffin"));
        public static final TagKey<Item> wool = IPTags.createItemWrapper(ResourceUtils.mc("wool"));
    }

    public static class Blocks {
        public static final TagKey<Block> asphalt = IPTags.createBlockTag(ResourceUtils.forge("asphalt"));
        public static final TagKey<Block> petcoke = IPTags.createBlockTag(ResourceUtils.forge("storage_blocks/petcoke"));
        public static final TagKey<Block> waxBlock = IPTags.createBlockTag(ResourceUtils.forge("storage_blocks/wax"));
        public static final TagKey<Block> paraffinWaxBlock = IPTags.createBlockTag(ResourceUtils.forge("storage_blocks/wax/paraffin"));
    }
}

