/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.command.type;

import com.blamejared.crafttweaker.api.command.CommandUtilities;
import com.blamejared.crafttweaker.api.command.argument.IItemStackArgument;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.plugin.ICommandRegistrationHandler;
import com.blamejared.crafttweaker.natives.entity.type.player.ExpandPlayer;
import com.blamejared.crafttweaker.platform.services.IEventHelper;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public final class MiscCommands {
    private static final String DOCS = "https://docs.blamejared.com";
    private static final String DISCORD = "https://discord.blamejared.com";
    private static final String ISSUES = "https://github.com/CraftTweaker/CraftTweaker/issues";
    private static final String PATREON = "https://patreon.com/jaredlll08";

    private MiscCommands() {
    }

    public static void registerCommands(ICommandRegistrationHandler handler) {
        handler.registerRootCommand("give", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.give"), builder -> ((LiteralArgumentBuilder)builder.requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"item", (ArgumentType)IItemStackArgument.get()).executes(context -> {
            ExpandPlayer.give((Player)((CommandSourceStack)context.getSource()).m_81375_(), (IItemStack)context.getArgument("item", IItemStack.class), -1);
            return 1;
        })));
        handler.registerRootCommand("reload", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.reload"), builder -> builder.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandUtilities.send(CommandUtilities.run(new TranslatableComponent("crafttweaker.command.misc.reload.info").m_130940_(ChatFormatting.AQUA), "/reload"), (Player)player);
            return 1;
        }));
        handler.registerRootCommand("discord", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.discord"), builder -> builder.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandUtilities.send(CommandUtilities.openingUrl(new TranslatableComponent("crafttweaker.command.misc.link", new Object[]{CommandUtilities.makeNoticeable(DISCORD)}).m_130940_(ChatFormatting.GREEN), DISCORD), (Player)player);
            return 1;
        }));
        handler.registerRootCommand("issues", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.issues"), builder -> builder.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandUtilities.send(CommandUtilities.openingUrl(new TranslatableComponent("crafttweaker.command.misc.link", new Object[]{CommandUtilities.makeNoticeable(ISSUES)}).m_130940_(ChatFormatting.GREEN), ISSUES), (Player)player);
            return 1;
        }));
        handler.registerRootCommand("patreon", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.patreon"), builder -> builder.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandUtilities.send(CommandUtilities.openingUrl(new TranslatableComponent("crafttweaker.command.misc.link", new Object[]{CommandUtilities.makeNoticeable(PATREON)}).m_130940_(ChatFormatting.GREEN), PATREON), (Player)player);
            return 1;
        }));
        Stream.of("wiki", "docs").forEach(id -> handler.registerRootCommand((String)id, (MutableComponent)new TranslatableComponent("crafttweaker.command.description.docs"), builder -> builder.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandUtilities.send(CommandUtilities.openingUrl(new TranslatableComponent("crafttweaker.command.misc.link", new Object[]{CommandUtilities.makeNoticeable(DOCS)}).m_130940_(ChatFormatting.GREEN), DOCS), (Player)player);
            return 1;
        })));
        handler.registerRootCommand("ctgui", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.docs"), builder -> builder.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandUtilities.send((Component)new TranslatableComponent("crafttweaker.command.misc.ctgui"), (Player)player);
            return 1;
        }));
        handler.registerRootCommand("block_info", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.info.block"), builder -> builder.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            if (IEventHelper.BLOCK_INFO_PLAYERS.contains(player)) {
                IEventHelper.BLOCK_INFO_PLAYERS.remove(player);
                CommandUtilities.send((Component)new TranslatableComponent("crafttweaker.command.info.block.deactivated"), (Player)player);
            } else {
                IEventHelper.BLOCK_INFO_PLAYERS.add((Player)player);
                CommandUtilities.send((Component)new TranslatableComponent("crafttweaker.command.info.block.activated"), (Player)player);
            }
            return 1;
        }));
        handler.registerRootCommand("entity_info", (MutableComponent)new TranslatableComponent("crafttweaker.command.description.info.entity"), builder -> builder.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            if (IEventHelper.ENTITY_INFO_PLAYERS.contains(player)) {
                IEventHelper.ENTITY_INFO_PLAYERS.remove(player);
                CommandUtilities.send((Component)new TranslatableComponent("crafttweaker.command.info.entity.deactivated"), (Player)player);
            } else {
                IEventHelper.ENTITY_INFO_PLAYERS.add((Player)player);
                CommandUtilities.send((Component)new TranslatableComponent("crafttweaker.command.info.entity.activated"), (Player)player);
            }
            return 1;
        }));
    }
}

