/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.navigation;

import dev.murad.shipping.block.rail.MultiShapeRail;
import dev.murad.shipping.entity.custom.train.locomotive.AbstractLocomotiveEntity;
import dev.murad.shipping.util.LocoRoute;
import dev.murad.shipping.util.LocoRouteNode;
import dev.murad.shipping.util.RailHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class LocomotiveNavigator {
    private final Set<BlockPos> routeNodes;
    private final Set<BlockPos> visitedNodes;
    private final HashMap<BlockPos, Direction> decisionCache;
    private final AbstractLocomotiveEntity locomotive;
    private static final String ROUTE_TAG = "route";
    private static final String VISITED_TAG = "visited";

    public int getRouteSize() {
        return this.routeNodes.size();
    }

    public int getVisitedSize() {
        return this.visitedNodes.size();
    }

    private void reset() {
        this.visitedNodes.clear();
        this.routeNodes.clear();
        this.decisionCache.clear();
    }

    public LocomotiveNavigator(AbstractLocomotiveEntity locomotive) {
        this.locomotive = locomotive;
        this.decisionCache = new HashMap();
        this.visitedNodes = new HashSet<BlockPos>();
        this.routeNodes = new HashSet<BlockPos>();
        this.reset();
    }

    private Optional<Direction> getDirectionFromHorizontalOffset(int x, int z) {
        if (x > 0) {
            return Optional.of(Direction.EAST);
        }
        if (x < 0) {
            return Optional.of(Direction.WEST);
        }
        if (z > 0) {
            return Optional.of(Direction.SOUTH);
        }
        if (z < 0) {
            return Optional.of(Direction.NORTH);
        }
        return Optional.empty();
    }

    public void serverTick() {
        RailHelper.getRail(this.locomotive.m_20097_().m_7494_(), this.locomotive.f_19853_).ifPresent(railPos -> {
            if (this.routeNodes.contains(railPos)) {
                this.visitedNodes.add((BlockPos)railPos);
            }
            if (this.visitedNodes.size() == this.routeNodes.size()) {
                this.visitedNodes.clear();
            }
            this.decisionCache.remove(railPos);
            BlockPos oldHorizontalBlockPos = this.locomotive.getOldHorizontalBlockPos();
            BlockPos blockPos = this.locomotive.getBlockPos();
            BlockPos offset = blockPos.m_141952_((Vec3i)oldHorizontalBlockPos.m_142393_(-1));
            Optional<Direction> moveDirOpt = this.getDirectionFromHorizontalOffset(offset.m_123341_(), offset.m_123343_());
            Direction moveDir = moveDirOpt.orElse(this.locomotive.m_6350_());
            this.locomotive.getRailHelper().getNext((BlockPos)railPos, moveDir).ifPresent(pair -> {
                MultiShapeRail s;
                BlockPos nextRail = (BlockPos)pair.getFirst();
                Direction prevExitTaken = (Direction)pair.getSecond();
                BlockState state = this.locomotive.m_183503_().m_8055_(nextRail);
                Block patt3127$temp = state.m_60734_();
                if (patt3127$temp instanceof MultiShapeRail && (s = (MultiShapeRail)patt3127$temp).isAutomaticSwitching()) {
                    List<Direction> choices = s.getPossibleOutputDirections(state, prevExitTaken.m_122424_()).stream().toList();
                    if (choices.size() == 1) {
                        s.setRailState(state, this.locomotive.f_19853_, nextRail, prevExitTaken.m_122424_(), (Direction)choices.get(0));
                    } else if (choices.size() > 1 && !this.routeNodes.isEmpty()) {
                        HashSet<BlockPos> potential = new HashSet<BlockPos>(this.routeNodes);
                        potential.removeAll(this.visitedNodes);
                        if (!this.decisionCache.containsKey(nextRail)) {
                            Direction decision = this.locomotive.getRailHelper().pickCheaperDir(choices, nextRail, RailHelper.samePositionHeuristicSet(potential), this.locomotive.m_183503_());
                            this.decisionCache.put(nextRail, decision);
                        }
                        s.setRailState(state, this.locomotive.f_19853_, nextRail, prevExitTaken.m_122424_(), this.decisionCache.get(nextRail));
                    }
                }
            });
        });
    }

    public void updateWithLocoRouteItem(LocoRoute route) {
        Set newRouteNodes = route.stream().map(LocoRouteNode::toBlockPos).collect(Collectors.toSet());
        if (newRouteNodes.equals(this.routeNodes)) {
            return;
        }
        this.reset();
        this.routeNodes.addAll(newRouteNodes);
    }

    public void loadFromNbt(@Nullable CompoundTag tag) {
        this.reset();
        if (tag == null) {
            return;
        }
        this.routeNodes.addAll(LocomotiveNavigator.convertTagToSet(tag.m_128437_(ROUTE_TAG, 11)));
        this.visitedNodes.addAll(LocomotiveNavigator.convertTagToSet(tag.m_128437_(VISITED_TAG, 11)));
    }

    public CompoundTag saveToNbt() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_(ROUTE_TAG, (Tag)LocomotiveNavigator.convertSetToTag(this.routeNodes));
        tag.m_128365_(VISITED_TAG, (Tag)LocomotiveNavigator.convertSetToTag(this.visitedNodes));
        return tag;
    }

    private static Set<BlockPos> convertTagToSet(@Nullable ListTag tag) {
        if (tag == null) {
            return new HashSet<BlockPos>();
        }
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        for (int i = 0; i < tag.size(); ++i) {
            int[] pos = tag.m_128767_(i);
            if (pos.length != 3) continue;
            set.add(new BlockPos(pos[0], pos[1], pos[2]));
        }
        return set;
    }

    private static ListTag convertSetToTag(Set<BlockPos> set) {
        ListTag tag = new ListTag();
        for (BlockPos pos : set) {
            tag.add((Object)new IntArrayTag(List.of(Integer.valueOf(pos.m_123341_()), Integer.valueOf(pos.m_123342_()), Integer.valueOf(pos.m_123343_()))));
        }
        return tag;
    }
}

