/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom.vessel.tug;

import dev.murad.shipping.ShippingConfig;
import dev.murad.shipping.entity.accessor.SteamHeadVehicleDataAccessor;
import dev.murad.shipping.entity.container.SteamHeadVehicleContainer;
import dev.murad.shipping.entity.custom.vessel.tug.AbstractTugEntity;
import dev.murad.shipping.setup.ModEntityTypes;
import dev.murad.shipping.setup.ModItems;
import dev.murad.shipping.setup.ModSounds;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class SteamTugEntity
extends AbstractTugEntity {
    private static final int FURNACE_FUEL_MULTIPLIER = (Integer)ShippingConfig.Server.STEAM_TUG_FUEL_MULTIPLIER.get();
    private final ItemStackHandler itemHandler = this.createHandler();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    protected int burnTime = 0;
    protected int burnCapacity = 0;

    public SteamTugEntity(EntityType<? extends WaterAnimal> type, Level world) {
        super(type, world);
    }

    public SteamTugEntity(Level worldIn, double x, double y, double z) {
        super((EntityType)ModEntityTypes.STEAM_TUG.get(), worldIn, x, y, z);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return FurnaceBlockEntity.m_58399_((ItemStack)stack);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Override
    protected MenuProvider createContainerProvider() {
        return new MenuProvider(){

            public Component m_5446_() {
                return new TranslatableComponent("screen.littlelogistics.tug");
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player Player2) {
                return new SteamHeadVehicleContainer(i, SteamTugEntity.this.f_19853_, SteamTugEntity.this.getDataAccessor(), playerInventory, Player2);
            }
        };
    }

    public int getBurnProgress() {
        int i = this.burnCapacity;
        if (i == 0) {
            i = 200;
        }
        return this.burnTime * 13 / i;
    }

    public boolean isLit() {
        return this.burnTime > 0;
    }

    @Override
    public SteamHeadVehicleDataAccessor getDataAccessor() {
        return new SteamHeadVehicleDataAccessor.Builder(this.m_142049_()).withBurnProgress(this::getBurnProgress).withLit(this::isLit).withVisitedSize(() -> this.nextStop).withOn(() -> this.engineOn).withRouteSize(() -> this.path != null ? this.path.size() : 0).build();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected boolean tickFuel() {
        if (this.burnTime > 0) {
            --this.burnTime;
            return true;
        }
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (!stack.m_41619_()) {
            this.burnCapacity = ForgeHooks.getBurnTime((ItemStack)stack, null) * FURNACE_FUEL_MULTIPLIER - 1;
            this.burnTime = this.burnCapacity - 1;
            stack.m_41774_(1);
            return true;
        }
        this.burnCapacity = 0;
        this.burnTime = 0;
        return false;
    }

    @Override
    public Item getDropItem() {
        return (Item)ModItems.STEAM_TUG.get();
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        this.burnTime = compound.m_128441_("burn") ? compound.m_128451_("burn") : 0;
        int n = this.burnCapacity = compound.m_128441_("burn_capacity") ? compound.m_128451_("burn_capacity") : 0;
        if (compound.m_128441_("inv")) {
            ItemStackHandler old = new ItemStackHandler();
            old.deserializeNBT(compound.m_128469_("inv"));
            this.itemHandler.setStackInSlot(0, old.getStackInSlot(1));
        } else {
            this.itemHandler.deserializeNBT(compound.m_128469_("tugItemHandler"));
        }
        super.m_7378_(compound);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        compound.m_128405_("burn", this.burnTime);
        compound.m_128405_("burn_capacity", this.burnCapacity);
        compound.m_128365_("tugItemHandler", (Tag)this.itemHandler.serializeNBT());
        super.m_7380_(compound);
    }

    @Override
    protected void onUndock() {
        super.onUndock();
        this.m_5496_((SoundEvent)ModSounds.STEAM_TUG_WHISTLE.get(), 1.0f, (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f);
    }

    public boolean m_7983_() {
        return this.itemHandler.getStackInSlot(0).m_41619_();
    }

    public ItemStack m_8020_(int p_70301_1_) {
        return this.itemHandler.getStackInSlot(p_70301_1_);
    }

    public void m_6836_(int p_70299_1_, ItemStack p_70299_2_) {
        if (!this.itemHandler.isItemValid(p_70299_1_, p_70299_2_)) {
            return;
        }
        this.itemHandler.insertItem(p_70299_1_, p_70299_2_, false);
        if (!p_70299_2_.m_41619_() && p_70299_2_.m_41613_() > this.m_6893_()) {
            p_70299_2_.m_41764_(this.m_6893_());
        }
    }
}

