/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import vectorwing.farmersdelight.common.crafting.ingredient.ChanceResult;
import vectorwing.farmersdelight.common.registry.ModRecipeSerializers;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;

public class CuttingBoardRecipe
implements Recipe<RecipeWrapper> {
    public static final int MAX_RESULTS = 4;
    private final ResourceLocation id;
    private final String group;
    private final Ingredient input;
    private final Ingredient tool;
    private final NonNullList<ChanceResult> results;
    private final String soundEvent;

    public CuttingBoardRecipe(ResourceLocation id, String group, Ingredient input, Ingredient tool, NonNullList<ChanceResult> results, String soundEvent) {
        this.id = id;
        this.group = group;
        this.input = input;
        this.tool = tool;
        this.results = results;
        this.soundEvent = soundEvent;
    }

    public boolean m_5598_() {
        return true;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonnulllist = NonNullList.m_122779_();
        nonnulllist.add((Object)this.input);
        return nonnulllist;
    }

    public NonNullList<Ingredient> getIngredientsAndTool() {
        NonNullList nonnulllist = NonNullList.m_122779_();
        nonnulllist.add((Object)this.input);
        nonnulllist.add((Object)this.tool);
        return nonnulllist;
    }

    public Ingredient getTool() {
        return this.tool;
    }

    public ItemStack assemble(RecipeWrapper inv) {
        return ((ChanceResult)this.results.get(0)).getStack().m_41777_();
    }

    public ItemStack m_8043_() {
        return ((ChanceResult)this.results.get(0)).getStack();
    }

    public List<ItemStack> getResults() {
        return this.getRollableResults().stream().map(ChanceResult::getStack).collect(Collectors.toList());
    }

    public NonNullList<ChanceResult> getRollableResults() {
        return this.results;
    }

    public List<ItemStack> rollResults(Random rand, int fortuneLevel) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        NonNullList<ChanceResult> rollableResults = this.getRollableResults();
        for (ChanceResult output : rollableResults) {
            ItemStack stack = output.rollOutput(rand, fortuneLevel);
            if (stack.m_41619_()) continue;
            results.add(stack);
        }
        return results;
    }

    public String getSoundEventID() {
        return this.soundEvent;
    }

    public boolean matches(RecipeWrapper inv, Level level) {
        if (inv.m_7983_()) {
            return false;
        }
        return this.input.test(inv.m_8020_(0));
    }

    protected int getMaxInputCount() {
        return 1;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= this.getMaxInputCount();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.CUTTING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.CUTTING.get();
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<CuttingBoardRecipe> {
        public CuttingBoardRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String groupIn = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> inputItemsIn = Serializer.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            JsonObject toolObject = GsonHelper.m_13930_((JsonObject)json, (String)"tool");
            Ingredient toolIn = Ingredient.m_43917_((JsonElement)toolObject);
            if (inputItemsIn.isEmpty()) {
                throw new JsonParseException("No ingredients for cutting recipe");
            }
            if (toolIn.m_43947_()) {
                throw new JsonParseException("No tool for cutting recipe");
            }
            if (inputItemsIn.size() > 1) {
                throw new JsonParseException("Too many ingredients for cutting recipe! Please define only one ingredient");
            }
            NonNullList<ChanceResult> results = Serializer.readResults(GsonHelper.m_13933_((JsonObject)json, (String)"result"));
            if (results.size() > 4) {
                throw new JsonParseException("Too many results for cutting recipe! The maximum quantity of unique results is 4");
            }
            String soundID = GsonHelper.m_13851_((JsonObject)json, (String)"sound", (String)"");
            return new CuttingBoardRecipe(recipeId, groupIn, (Ingredient)inputItemsIn.get(0), toolIn, results, soundID);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientArray.get(i));
                if (ingredient.m_43947_()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        private static NonNullList<ChanceResult> readResults(JsonArray resultArray) {
            NonNullList results = NonNullList.m_122779_();
            for (JsonElement result : resultArray) {
                results.add((Object)ChanceResult.deserialize(result));
            }
            return results;
        }

        @Nullable
        public CuttingBoardRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String groupIn = buffer.m_130136_(Short.MAX_VALUE);
            Ingredient inputItemIn = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient toolIn = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int i = buffer.m_130242_();
            NonNullList resultsIn = NonNullList.m_122780_((int)i, (Object)ChanceResult.EMPTY);
            for (int j = 0; j < resultsIn.size(); ++j) {
                resultsIn.set(j, (Object)ChanceResult.read(buffer));
            }
            String soundEventIn = buffer.m_130277_();
            return new CuttingBoardRecipe(recipeId, groupIn, inputItemIn, toolIn, (NonNullList<ChanceResult>)resultsIn, soundEventIn);
        }

        public void toNetwork(FriendlyByteBuf buffer, CuttingBoardRecipe recipe) {
            buffer.m_130070_(recipe.group);
            recipe.input.m_43923_(buffer);
            recipe.tool.m_43923_(buffer);
            buffer.m_130130_(recipe.results.size());
            for (ChanceResult result : recipe.results) {
                result.write(buffer);
            }
            buffer.m_130070_(recipe.soundEvent);
        }
    }
}

