/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.datagen.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.common.recipes.ModCraftingHelper;
import me.desht.pneumaticcraft.datagen.recipe.PneumaticCraftRecipeBuilder;
import me.desht.pneumaticcraft.datagen.recipe.SerializerHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;

public class ThermoPlantRecipeBuilder
extends PneumaticCraftRecipeBuilder<ThermoPlantRecipeBuilder> {
    private final FluidIngredient inputFluid;
    @Nullable
    private final Ingredient inputItem;
    private final FluidStack outputFluid;
    private final ItemStack outputItem;
    private final TemperatureRange operatingTemperature;
    private final float requiredPressure;
    private final float recipeSpeed;
    private final float airUseMultiplier;
    private final boolean exothermic;

    public ThermoPlantRecipeBuilder(FluidIngredient inputFluid, @Nullable Ingredient inputItem, FluidStack outputFluid, ItemStack outputItem, TemperatureRange operatingTemperature, float requiredPressure, float recipeSpeed, float airUseMultiplier, boolean exothermic) {
        super(PneumaticRegistry.RL("thermo_plant"));
        this.inputFluid = inputFluid;
        this.inputItem = inputItem;
        this.outputFluid = outputFluid;
        this.outputItem = outputItem;
        this.operatingTemperature = operatingTemperature;
        this.requiredPressure = requiredPressure;
        this.recipeSpeed = recipeSpeed;
        this.airUseMultiplier = airUseMultiplier;
        this.exothermic = exothermic;
    }

    @Override
    protected PneumaticCraftRecipeBuilder.RecipeResult getResult(ResourceLocation id) {
        return new ThermoPlantRecipeResult(id);
    }

    public class ThermoPlantRecipeResult
    extends PneumaticCraftRecipeBuilder.RecipeResult {
        ThermoPlantRecipeResult(ResourceLocation id) {
            super(ThermoPlantRecipeBuilder.this, id);
        }

        public void m_7917_(JsonObject json) {
            if (ThermoPlantRecipeBuilder.this.inputItem != Ingredient.f_43901_) {
                json.add("item_input", ThermoPlantRecipeBuilder.this.inputItem.m_43942_());
            }
            if (ThermoPlantRecipeBuilder.this.inputFluid != FluidIngredient.EMPTY) {
                json.add("fluid_input", ThermoPlantRecipeBuilder.this.inputFluid.m_43942_());
            }
            if (!ThermoPlantRecipeBuilder.this.outputItem.m_41619_()) {
                json.add("item_output", SerializerHelper.serializeOneItemStack(ThermoPlantRecipeBuilder.this.outputItem));
            }
            if (!ThermoPlantRecipeBuilder.this.outputFluid.isEmpty()) {
                json.add("fluid_output", (JsonElement)ModCraftingHelper.fluidStackToJson(ThermoPlantRecipeBuilder.this.outputFluid));
            }
            if (!ThermoPlantRecipeBuilder.this.operatingTemperature.isAny()) {
                json.add("temperature", (JsonElement)ThermoPlantRecipeBuilder.this.operatingTemperature.toJson());
            }
            if (ThermoPlantRecipeBuilder.this.requiredPressure != 0.0f) {
                json.addProperty("pressure", (Number)Float.valueOf(ThermoPlantRecipeBuilder.this.requiredPressure));
            }
            if (ThermoPlantRecipeBuilder.this.recipeSpeed != 1.0f) {
                json.addProperty("speed", (Number)Float.valueOf(ThermoPlantRecipeBuilder.this.recipeSpeed));
            }
            if (ThermoPlantRecipeBuilder.this.airUseMultiplier != 1.0f) {
                json.addProperty("air_use_multiplier", (Number)Float.valueOf(ThermoPlantRecipeBuilder.this.airUseMultiplier));
            }
            json.addProperty("exothermic", Boolean.valueOf(ThermoPlantRecipeBuilder.this.exothermic));
        }
    }
}

