/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.datagen.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.datagen.recipe.Criteria;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class PneumaticCraftRecipeBuilder<T extends PneumaticCraftRecipeBuilder<T>> {
    protected final List<ICondition> conditions = new ArrayList<ICondition>();
    protected final Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_();
    protected final ResourceLocation serializerName;

    protected PneumaticCraftRecipeBuilder(ResourceLocation serializerName) {
        this.serializerName = serializerName;
    }

    public T addCriterion(Criteria.RecipeCriterion criterion) {
        return this.addCriterion(criterion.name, criterion.criterion);
    }

    public T addCriterion(String name, CriterionTriggerInstance criterion) {
        this.advancementBuilder.m_138386_(name, criterion);
        return (T)this;
    }

    public T addCondition(ICondition condition) {
        this.conditions.add(condition);
        return (T)this;
    }

    protected abstract RecipeResult getResult(ResourceLocation var1);

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.advancementBuilder.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
        this.advancementBuilder.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)new RecipeUnlockedTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_, id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept(this.getResult(id));
    }

    protected abstract class RecipeResult
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final ResourceLocation advancementId;

        RecipeResult(ResourceLocation id) {
            this.id = id;
            this.advancementId = new ResourceLocation(id.m_135827_(), "recipes/" + id.m_135815_());
        }

        public JsonObject m_125966_() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("type", PneumaticCraftRecipeBuilder.this.serializerName.toString());
            if (!PneumaticCraftRecipeBuilder.this.conditions.isEmpty()) {
                JsonArray conditionsArray = new JsonArray();
                for (ICondition condition : PneumaticCraftRecipeBuilder.this.conditions) {
                    conditionsArray.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
                }
                jsonObject.add("conditions", (JsonElement)conditionsArray);
            }
            this.m_7917_(jsonObject);
            return jsonObject;
        }

        @Nonnull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ForgeRegistries.RECIPE_SERIALIZERS.getValue(PneumaticCraftRecipeBuilder.this.serializerName);
        }

        @Nonnull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return PneumaticCraftRecipeBuilder.this.advancementBuilder.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

