/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei.ghost;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.semiblock.AbstractLogisticsScreen;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractLogisticsFrameEntity;
import me.desht.pneumaticcraft.common.inventory.LogisticsMenu;
import me.desht.pneumaticcraft.common.inventory.slot.PhantomSlot;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class LogisticsFilterGhost<T extends AbstractLogisticsFrameEntity>
implements IGhostIngredientHandler<AbstractLogisticsScreen<T>> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargets(AbstractLogisticsScreen<T> gui, I ingredient, boolean doStart) {
        if (ingredient instanceof ItemStack) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Slot slot : ((LogisticsMenu)gui.m_6262_()).f_38839_) {
                if (!(slot instanceof PhantomSlot)) continue;
                PhantomSlot ps = (PhantomSlot)slot;
                builder.add((Object)new ItemStackTarget(ps, gui));
            }
            FluidUtil.getFluidContained((ItemStack)((ItemStack)ingredient)).ifPresent(fluidStack -> {
                for (int i = 0; i < 9; ++i) {
                    builder.add((Object)new FluidStackItemTarget(i, gui));
                }
            });
            return builder.build();
        }
        if (ingredient instanceof FluidStack) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < 9; ++i) {
                builder.add((Object)new FluidStackTarget(i, gui));
            }
            return builder.build();
        }
        return Collections.emptyList();
    }

    public void onComplete() {
    }

    private record ItemStackTarget(PhantomSlot slot, AbstractLogisticsScreen<?> gui) implements IGhostIngredientHandler.Target<ItemStack>
    {
        public Rect2i getArea() {
            return new Rect2i(this.gui.getGuiLeft() + this.slot.f_40220_, this.gui.getGuiTop() + this.slot.f_40221_, 16, 16);
        }

        public void accept(ItemStack ingredient) {
            this.gui.updateItemFilter(this.slot.getSlotIndex(), ingredient.m_41777_());
        }
    }

    private record FluidStackTarget(int slotNumber, AbstractLogisticsScreen<?> gui) implements IGhostIngredientHandler.Target<FluidStack>
    {
        public Rect2i getArea() {
            PointXY p = this.gui.getFluidSlotPos(this.slotNumber);
            return new Rect2i(p.x(), p.y(), 16, 16);
        }

        public void accept(FluidStack ingredient) {
            this.gui.updateFluidFilter(this.slotNumber, ingredient.copy());
        }
    }

    private record FluidStackItemTarget(int slotNumber, AbstractLogisticsScreen<?> gui) implements IGhostIngredientHandler.Target<ItemStack>
    {
        public Rect2i getArea() {
            PointXY p = this.gui.getFluidSlotPos(this.slotNumber);
            return new Rect2i(p.x(), p.y(), 16, 16);
        }

        public void accept(ItemStack ingredient) {
            FluidUtil.getFluidContained((ItemStack)ingredient).ifPresent(fluidStack -> this.gui.updateFluidFilter(this.slotNumber, (FluidStack)fluidStack));
        }
    }
}

