/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import me.desht.pneumaticcraft.api.crafting.recipe.HeatPropertiesRecipe;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.heat.BlockHeatProperties;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import me.desht.pneumaticcraft.common.thirdparty.jei.AbstractPNCCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIPlugin;
import me.desht.pneumaticcraft.common.thirdparty.jei.RecipeTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class JEIBlockHeatPropertiesCategory
extends AbstractPNCCategory<HeatPropertiesRecipe> {
    private final IDrawable hotArea = JEIBlockHeatPropertiesCategory.guiHelper().createDrawable(Textures.GUI_JEI_HEAT_PROPERTIES, 150, 0, 31, 18);
    private final IDrawable coldArea = JEIBlockHeatPropertiesCategory.guiHelper().createDrawable(Textures.GUI_JEI_HEAT_PROPERTIES, 150, 18, 31, 18);
    private final IDrawable air = JEIBlockHeatPropertiesCategory.guiHelper().createDrawable(Textures.GUI_JEI_HEAT_PROPERTIES, 150, 36, 16, 16);
    private static final Rect2i INPUT_AREA = new Rect2i(65, 44, 18, 18);
    private static final Rect2i COLD_AREA = new Rect2i(5, 44, 18, 18);
    private static final Rect2i HOT_AREA = new Rect2i(125, 44, 18, 18);
    private static final Rect2i[] OUTPUT_AREAS = new Rect2i[]{COLD_AREA, HOT_AREA};

    public JEIBlockHeatPropertiesCategory() {
        super(RecipeTypes.HEAT_PROPERTIES, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.jei.title.heatProperties", new Object[0]), (IDrawable)JEIBlockHeatPropertiesCategory.guiHelper().createDrawable(Textures.GUI_JEI_HEAT_PROPERTIES, 0, 0, 146, 73), (IDrawable)JEIBlockHeatPropertiesCategory.guiHelper().drawableBuilder(Textures.JEI_THERMOMETER, 0, 0, 16, 16).setTextureSize(16, 16).build());
    }

    public static List<HeatPropertiesRecipe> getAllRecipes() {
        return BlockHeatProperties.getInstance().getAllEntries((Level)Minecraft.m_91087_().f_91073_).stream().filter(r -> r.getBlock() instanceof LiquidBlock || !new ItemStack((ItemLike)r.getBlock()).m_41619_()).sorted(Comparator.comparingInt(HeatPropertiesRecipe::getTemperature).thenComparing(o -> o.getInputDisplayName().getString())).toList();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, HeatPropertiesRecipe recipe, IFocusGroup focuses) {
        this.setInputIngredient(builder, recipe);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
        this.collectOutputs(recipe.getTransformCold(), items, fluids);
        this.collectOutputs(recipe.getTransformHot(), items, fluids);
        for (int idx = 0; idx < 2; ++idx) {
            if (!((FluidStack)fluids.get(idx)).isEmpty()) {
                builder.addSlot(RecipeIngredientRole.OUTPUT, OUTPUT_AREAS[idx].m_110085_() + 2, OUTPUT_AREAS[idx].m_110086_() - 1).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)((FluidStack)fluids.get(idx)));
                continue;
            }
            if (((ItemStack)items.get(idx)).m_41619_()) continue;
            builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack((ItemStack)items.get(idx));
        }
    }

    private void collectOutputs(BlockState state, List<ItemStack> items, List<FluidStack> fluids) {
        if (state != null) {
            Block block = state.m_60734_();
            if (block instanceof LiquidBlock) {
                int level;
                LiquidBlock l = (LiquidBlock)block;
                int n = level = state.m_61138_((Property)LiquidBlock.f_54688_) ? (Integer)state.m_61143_((Property)LiquidBlock.f_54688_) : 15;
                if (level == 0) {
                    level = 15;
                }
                FluidStack stack = new FluidStack((Fluid)l.getFluid(), 1000 * level / 15);
                fluids.add(stack);
                items.add(new ItemStack((ItemLike)Blocks.f_50375_));
            } else {
                ItemStack stack = new ItemStack((ItemLike)state.m_60734_());
                items.add(stack.m_41619_() ? new ItemStack((ItemLike)Blocks.f_50375_) : stack);
                fluids.add(FluidStack.EMPTY);
            }
        } else {
            items.add(new ItemStack((ItemLike)Blocks.f_50375_));
            fluids.add(FluidStack.EMPTY);
        }
    }

    private void setInputIngredient(IRecipeLayoutBuilder builder, HeatPropertiesRecipe recipe) {
        Block block = recipe.getBlock();
        if (block instanceof LiquidBlock) {
            LiquidBlock l = (LiquidBlock)block;
            FluidStack stack = new FluidStack((Fluid)l.getFluid(), 1000);
            builder.addSlot(RecipeIngredientRole.INPUT, INPUT_AREA.m_110085_() + 2, INPUT_AREA.m_110086_() - 1).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)stack);
        } else {
            builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStack(new ItemStack((ItemLike)block));
        }
    }

    public void draw(HeatPropertiesRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        Objects.requireNonNull(fontRenderer);
        int h = 9;
        Component desc = recipe.getDescriptionKey().isEmpty() ? TextComponent.f_131282_ : new TextComponent(" (" + I18n.m_118938_((String)recipe.getDescriptionKey(), (Object[])new Object[0]) + ")");
        fontRenderer.m_92889_(matrixStack, (Component)recipe.getInputDisplayName().m_6881_().m_7220_(desc), 0.0f, 0.0f, 0x4040A0);
        MutableComponent temp = PneumaticCraftUtils.xlate("pneumaticcraft.waila.temperature", new Object[0]).m_7220_((Component)new TextComponent(recipe.getTemperature() - 273 + "\u00b0C"));
        fontRenderer.m_92889_(matrixStack, (Component)temp, 0.0f, (float)(h * 2), 0x404040);
        String res = NumberFormat.getNumberInstance(Locale.getDefault()).format(recipe.getThermalResistance());
        fontRenderer.m_92883_(matrixStack, I18n.m_118938_((String)"pneumaticcraft.gui.jei.thermalResistance", (Object[])new Object[0]) + res, 0.0f, (float)(h * 3), 0x404040);
        boolean showCapacity = false;
        if (recipe.getTransformCold() != null) {
            this.coldArea.draw(matrixStack, INPUT_AREA.m_110085_() - this.coldArea.getWidth() - 5, 42);
            showCapacity = true;
        }
        if (recipe.getTransformHot() != null) {
            this.hotArea.draw(matrixStack, HOT_AREA.m_110085_() - this.hotArea.getWidth() - 5, 42);
            showCapacity = true;
        }
        this.renderBlock(recipe.getBlockState(), matrixStack, INPUT_AREA.m_110085_() + 9, INPUT_AREA.m_110086_() + 1);
        this.renderBlock(recipe.getTransformCold(), matrixStack, COLD_AREA.m_110085_() + 9, COLD_AREA.m_110086_() + 1);
        this.renderBlock(recipe.getTransformHot(), matrixStack, HOT_AREA.m_110085_() + 9, HOT_AREA.m_110086_() + 1);
        if (showCapacity) {
            fontRenderer.m_92889_(matrixStack, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.jei.heatCapacity", NumberFormat.getNumberInstance(Locale.getDefault()).format(recipe.getHeatCapacity())), 0.0f, (float)(this.getBackground().getHeight() - h), 0x404040);
        }
    }

    public boolean handleInput(HeatPropertiesRecipe recipe, double mouseX, double mouseY, InputConstants.Key input) {
        if (input.m_84868_() == InputConstants.Type.MOUSE) {
            int mouseButton = input.m_84873_();
            IFocus<?> focus = null;
            if (INPUT_AREA.m_110087_((int)mouseX, (int)mouseY)) {
                focus = this.makeFocus(recipe.getBlock(), mouseButton == 0 ? RecipeIngredientRole.OUTPUT : RecipeIngredientRole.INPUT);
            } else if (recipe.getTransformCold() != null && COLD_AREA.m_110087_((int)mouseX, (int)mouseY)) {
                focus = this.makeFocus(recipe.getTransformCold().m_60734_(), mouseButton == 0 ? RecipeIngredientRole.OUTPUT : RecipeIngredientRole.INPUT);
            } else if (recipe.getTransformHot() != null && HOT_AREA.m_110087_((int)mouseX, (int)mouseY)) {
                focus = this.makeFocus(recipe.getTransformHot().m_60734_(), mouseButton == 0 ? RecipeIngredientRole.OUTPUT : RecipeIngredientRole.INPUT);
            }
            if (focus != null) {
                JEIPlugin.recipesGui.show(focus);
                return true;
            }
        }
        return false;
    }

    public List<Component> getTooltipStrings(HeatPropertiesRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> l = new ArrayList<Component>();
        if (INPUT_AREA.m_110087_((int)mouseX, (int)mouseY)) {
            this.addTooltip(recipe.getBlock(), l);
        } else if (recipe.getTransformCold() != null && COLD_AREA.m_110087_((int)mouseX, (int)mouseY)) {
            this.addTooltip(recipe.getTransformCold().m_60734_(), l);
        } else if (recipe.getTransformHot() != null && HOT_AREA.m_110087_((int)mouseX, (int)mouseY)) {
            this.addTooltip(recipe.getTransformHot().m_60734_(), l);
        } else if (mouseY > 20.0 && mouseY < 30.0) {
            l.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.jei.tooltip.thermalResistance", new Object[0]));
        } else if (recipe.getHeatCapacity() != 0 && mouseY > 62.0) {
            l.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.jei.tooltip.heatCapacity", new Object[0]));
        }
        return l;
    }

    private IFocus<?> makeFocus(Block block, RecipeIngredientRole mode) {
        return block == Blocks.f_50016_ || block instanceof LiquidBlock ? null : JEIPlugin.jeiHelpers.getFocusFactory().createFocus(mode, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)block));
    }

    private void addTooltip(Block block, List<Component> list) {
        ItemStack stack = new ItemStack((ItemLike)block);
        list.add(stack.m_41786_());
        stack.m_41720_().m_7373_(stack, ClientUtils.getClientLevel(), list, (TooltipFlag)(ClientUtils.hasShiftDown() ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
        if (Minecraft.m_91087_().f_91066_.f_92125_) {
            list.add((Component)new TextComponent(stack.m_41720_().getRegistryName().toString()).m_130940_(ChatFormatting.DARK_GRAY));
        }
        list.add((Component)new TextComponent(ModNameCache.getModName(stack.m_41720_())).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
    }

    private void renderBlock(BlockState state, PoseStack matrixStack, int x, int y) {
        if (state != null) {
            if (state.m_60734_() == Blocks.f_50016_) {
                this.air.draw(matrixStack, x - 8, y - 2);
            } else {
                float rot = Minecraft.m_91087_().f_91073_.m_46467_() % 360L;
                GuiUtils.renderBlockInGui(matrixStack, state, x, y, 100.0f, rot, 15.0f);
            }
        }
    }
}

