/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.other;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.api.crafting.recipe.FuelQualityRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import me.desht.pneumaticcraft.common.core.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.core.ModRecipeTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.Validate;

public class FuelQualityRecipeImpl
extends FuelQualityRecipe {
    private final FluidIngredient fuel;
    private final int airPerBucket;
    private final float burnRate;

    public FuelQualityRecipeImpl(ResourceLocation id, FluidIngredient fuel, int airPerBucket, float burnRate) {
        super(id);
        Validate.isTrue((fuel.getAmount() > 0 ? 1 : 0) != 0);
        this.fuel = fuel;
        this.airPerBucket = airPerBucket * (1000 / fuel.getAmount());
        this.burnRate = burnRate;
    }

    @Override
    public boolean matchesFluid(Fluid inputFluid) {
        return this.fuel.testFluid(inputFluid);
    }

    @Override
    public FluidIngredient getFuel() {
        return this.fuel;
    }

    @Override
    public int getAirPerBucket() {
        return this.airPerBucket;
    }

    @Override
    public float getBurnRate() {
        return this.burnRate;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        this.fuel.m_43923_(buffer);
        buffer.writeInt(this.airPerBucket);
        buffer.writeFloat(this.burnRate);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.FUEL_QUALITY.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.FUEL_QUALITY.get();
    }

    public static class Serializer<T extends FuelQualityRecipe>
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient fluidInput = FluidIngredient.m_43917_((JsonElement)json.get("fluid"));
            int airPerBucket = GsonHelper.m_13927_((JsonObject)json, (String)"air_per_bucket");
            float burnRate = GsonHelper.m_13820_((JsonObject)json, (String)"burn_rate", (float)1.0f);
            return this.factory.create(recipeId, (FluidIngredient)fluidInput, airPerBucket, burnRate);
        }

        @Nullable
        public T fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            FluidIngredient fluidIn = (FluidIngredient)Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int airPerBucket = buffer.readInt();
            float burnRate = buffer.readFloat();
            return this.factory.create(recipeId, fluidIn, airPerBucket, burnRate);
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            ((PneumaticCraftRecipe)recipe).write(buffer);
        }

        public static interface IFactory<T extends FuelQualityRecipe> {
            public T create(ResourceLocation var1, FluidIngredient var2, int var3, float var4);
        }
    }
}

