/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.ai.DroneAIForEachCoordinate;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.progwidgets.IJump;
import me.desht.pneumaticcraft.common.progwidgets.IJumpBackWidget;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.IVariableSetWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetJump;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetText;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;

public class ProgWidgetForEachCoordinate
extends ProgWidgetAreaItemBase
implements IJumpBackWidget,
IJump,
IVariableSetWidget {
    private String elementVariable = "";
    private final Set<BlockPos> traversedPositions = new HashSet<BlockPos>();
    private DroneAIForEachCoordinate ai;

    public ProgWidgetForEachCoordinate() {
        super((ProgWidgetType)((Object)ModProgWidgets.FOR_EACH_COORDINATE.get()));
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.YELLOW;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_FOR_EACH_COORDINATE;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of((Object)((Object)((ProgWidgetType)((Object)ModProgWidgets.AREA.get()))), (Object)((Object)((ProgWidgetType)((Object)ModProgWidgets.TEXT.get()))));
    }

    @Override
    public void addVariables(Set<String> variables) {
        super.addVariables(variables);
        variables.add(this.elementVariable);
    }

    @Override
    public String getVariable() {
        return this.elementVariable;
    }

    @Override
    public void setVariable(String variable) {
        this.elementVariable = variable;
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        if (!this.elementVariable.isEmpty()) {
            tag.m_128359_("variable", this.elementVariable);
        }
        super.writeToNBT(tag);
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        this.elementVariable = tag.m_128461_("variable");
        super.readFromNBT(tag);
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buf) {
        super.writeToPacket(buf);
        buf.m_130070_(this.elementVariable);
    }

    @Override
    public void readFromPacket(FriendlyByteBuf buf) {
        super.readFromPacket(buf);
        this.elementVariable = buf.m_130136_(64);
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.ADVANCED;
    }

    @Override
    public IProgWidget getOutputWidget(IDroneBase drone, List<IProgWidget> allWidgets) {
        BlockPos pos;
        List<String> locations = this.getPossibleJumpLocations();
        BlockPos varPos = this.aiManager.getCoordinate(drone.getOwnerUUID(), this.elementVariable).orElse(PneumaticCraftUtils.invalidPos());
        if (!(locations.isEmpty() || this.ai == null || this.traversedPositions.size() != 1 && drone.world().m_151570_(varPos) || (pos = this.ai.getCurCoord()) == null)) {
            this.aiManager.setCoordinate(this.elementVariable, pos);
            return ProgWidgetJump.jumpToLabel(drone, allWidgets, locations.get(0));
        }
        this.traversedPositions.clear();
        return super.getOutputWidget(drone, allWidgets);
    }

    @Override
    public List<String> getPossibleJumpLocations() {
        List<String> list;
        IProgWidget widget = this.getConnectedParameters()[this.getParameters().size() - 1];
        if (widget instanceof ProgWidgetText) {
            ProgWidgetText t = (ProgWidgetText)widget;
            list = Collections.singletonList(t.string);
        } else {
            list = Collections.emptyList();
        }
        return list;
    }

    @Override
    public Goal getWidgetAI(IDroneBase drone, IProgWidget widget) {
        this.ai = new DroneAIForEachCoordinate(drone, (ProgWidgetForEachCoordinate)widget);
        return this.ai;
    }

    public boolean isValidPosition(BlockPos pos) {
        return this.traversedPositions.add(pos);
    }

    @Override
    public boolean canBeRunByComputers(IDroneBase drone, IProgWidget widget) {
        return false;
    }

    @Override
    public List<Component> getExtraStringInfo() {
        return Collections.singletonList(this.varAsTextComponent(this.elementVariable));
    }

    @Override
    public boolean canSetParameter(int index) {
        return index != 2;
    }
}

