/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.ai.DroneAICrafting;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.progwidgets.ICountWidget;
import me.desht.pneumaticcraft.common.progwidgets.ICraftingWidget;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetItemFilter;
import me.desht.pneumaticcraft.common.recipes.RecipeCache;
import me.desht.pneumaticcraft.common.util.DummyContainer;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class ProgWidgetCrafting
extends ProgWidget
implements ICraftingWidget,
ICountWidget,
ISidedWidget {
    private static final boolean[] NO_SIDES = new boolean[6];
    private boolean useCount;
    private int count;
    private boolean usingVariables;

    public ProgWidgetCrafting() {
        super((ProgWidgetType)((Object)ModProgWidgets.CRAFTING.get()));
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        this.getCraftingGrid();
        if (!this.usingVariables && this.getRecipeResult(ClientUtils.getClientLevel()).m_41619_()) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.crafting.error.noCraftingRecipe", new Object[0]));
        }
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        ItemStack stack = this.getRecipeResult(ClientUtils.getClientLevel());
        if (!stack.m_41619_()) {
            curTooltip.add((Component)stack.m_41786_().m_6881_().m_130940_(ChatFormatting.YELLOW));
        }
        if (this.useCount()) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.inventory.usingCount", this.getCount()));
        }
    }

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return null;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of((Object)((Object)((ProgWidgetType)((Object)ModProgWidgets.ITEM_FILTER.get()))), (Object)((Object)((ProgWidgetType)((Object)ModProgWidgets.ITEM_FILTER.get()))), (Object)((Object)((ProgWidgetType)((Object)ModProgWidgets.ITEM_FILTER.get()))));
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.PURPLE;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CRAFTING;
    }

    @Override
    protected boolean hasBlacklist() {
        return false;
    }

    @Override
    public CraftingContainer getCraftingGrid() {
        this.usingVariables = false;
        CraftingContainer invCrafting = new CraftingContainer((AbstractContainerMenu)new DummyContainer(), 3, 3);
        for (int y = 0; y < 3; ++y) {
            ProgWidgetItemFilter itemFilter = (ProgWidgetItemFilter)this.getConnectedParameters()[y];
            for (int x = 0; x < 3 && itemFilter != null; ++x) {
                if (!itemFilter.getVariable().isEmpty()) {
                    this.usingVariables = true;
                }
                invCrafting.m_6836_(y * 3 + x, itemFilter.getFilter());
                itemFilter = (ProgWidgetItemFilter)itemFilter.getConnectedParameters()[0];
            }
        }
        return invCrafting;
    }

    public ItemStack getRecipeResult(Level world) {
        CraftingContainer grid = this.getCraftingGrid();
        return this.getRecipe(world, grid).map(r -> r.m_5874_((Container)grid)).orElse(ItemStack.f_41583_);
    }

    @Override
    public Optional<CraftingRecipe> getRecipe(Level world, CraftingContainer grid) {
        return this.usingVariables ? world.m_7465_().m_44015_(RecipeType.f_44107_, (Container)grid, world) : RecipeCache.CRAFTING.getCachedRecipe(world, grid);
    }

    public static Recipe<CraftingContainer> getRecipe(Level world, ICraftingWidget widget) {
        return widget.getRecipe(world, widget.getCraftingGrid()).orElse(null);
    }

    @Override
    public Goal getWidgetAI(IDroneBase drone, IProgWidget widget) {
        return new DroneAICrafting(drone, (ICraftingWidget)((Object)widget));
    }

    @Override
    public void setSides(boolean[] sides) {
    }

    @Override
    public boolean[] getSides() {
        return NO_SIDES;
    }

    @Override
    public boolean useCount() {
        return this.useCount;
    }

    @Override
    public void setUseCount(boolean useCount) {
        this.useCount = useCount;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        if (this.useCount) {
            tag.m_128379_("useCount", true);
        }
        tag.m_128405_("count", this.count);
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.useCount = tag.m_128471_("useCount");
        this.count = tag.m_128451_("count");
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buf) {
        super.writeToPacket(buf);
        buf.writeBoolean(this.useCount);
        buf.m_130130_(this.count);
    }

    @Override
    public void readFromPacket(FriendlyByteBuf buf) {
        super.readFromPacket(buf);
        this.useCount = buf.readBoolean();
        this.count = buf.m_130242_();
    }
}

