/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.Arrays;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.entity.RingEntity;
import me.desht.pneumaticcraft.common.network.LocationDoublePacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class PacketSpawnRing
extends LocationDoublePacket {
    private final int[] colors;
    private final int targetEntityId;

    public PacketSpawnRing(double x, double y, double z, Entity targetEntity, int ... colors) {
        super(x, y, z);
        this.targetEntityId = targetEntity.m_142049_();
        this.colors = colors;
    }

    public PacketSpawnRing(FriendlyByteBuf buffer) {
        super(buffer);
        this.targetEntityId = buffer.readInt();
        this.colors = new int[buffer.m_130242_()];
        for (int i = 0; i < this.colors.length; ++i) {
            this.colors[i] = buffer.readInt();
        }
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeInt(this.targetEntityId);
        buffer.m_130130_(this.colors.length);
        Arrays.stream(this.colors).forEach(arg_0 -> ((FriendlyByteBuf)buffer).writeInt(arg_0));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Level world = ClientUtils.getClientLevel();
            Entity entity = world.m_6815_(this.targetEntityId);
            if (entity != null) {
                for (int color : this.colors) {
                    ClientUtils.spawnEntityClientside(new RingEntity(world, this.x, this.y, this.z, entity, color));
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

