/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.network.LocationDoublePacket;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class PacketSpawnParticleTrail
extends LocationDoublePacket {
    private final ParticleOptions particle;
    private final double x2;
    private final double y2;
    private final double z2;

    public PacketSpawnParticleTrail(ParticleOptions particle, double x1, double y1, double z1, double x2, double y2, double z2) {
        super(x1, y1, z1);
        this.particle = particle;
        this.x2 = x2;
        this.y2 = y2;
        this.z2 = z2;
    }

    public PacketSpawnParticleTrail(FriendlyByteBuf buffer) {
        super(buffer);
        ParticleType type = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(buffer.m_130281_());
        assert (type != null);
        this.x2 = buffer.readDouble();
        this.y2 = buffer.readDouble();
        this.z2 = buffer.readDouble();
        this.particle = this.readParticle(type, buffer);
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        super.toBytes(buffer);
        buffer.m_130085_(Objects.requireNonNull(this.particle.m_6012_().getRegistryName()));
        buffer.writeDouble(this.x2);
        buffer.writeDouble(this.y2);
        buffer.writeDouble(this.z2);
        this.particle.m_7711_(new FriendlyByteBuf((ByteBuf)buffer));
    }

    private <T extends ParticleOptions> T readParticle(ParticleType<T> type, FriendlyByteBuf buffer) {
        return (T)type.m_123743_().m_6507_(type, buffer);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Level world = ClientUtils.getClientLevel();
            int numParticles = (int)PneumaticCraftUtils.distBetween(this.x, this.y, this.z, this.x2, this.y2, this.z2) * 25;
            if (numParticles == 0) {
                numParticles = 1;
            }
            for (int i = 0; i <= numParticles; ++i) {
                double pct = (double)i / (double)numParticles;
                double px = Mth.m_14139_((double)pct, (double)this.x, (double)this.x2);
                double py = Mth.m_14139_((double)pct, (double)this.y, (double)this.y2);
                double pz = Mth.m_14139_((double)pct, (double)this.z, (double)this.z2);
                world.m_7106_(this.particle, px + world.f_46441_.nextDouble() * 0.2 - 0.1, py + world.f_46441_.nextDouble() * 0.2 - 0.1, pz + world.f_46441_.nextDouble() * 0.2 - 0.1, 0.0, 0.0, 0.0);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

