/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.block.IPneumaticWrenchable;
import me.desht.pneumaticcraft.api.pressure.IPressurizableItem;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.common.advancements.AdvancementTriggers;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.item.PressurizableItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.thirdparty.ModdedWrenchUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;

public class PneumaticWrenchItem
extends PressurizableItem {
    public PneumaticWrenchItem() {
        super(ModItems.toolProps(), 30000, 3000);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
        InteractionHand hand = ctx.m_43724_();
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        if (!world.f_46443_) {
            BlockState state = world.m_8055_(pos);
            InteractionResult res = ModdedWrenchUtils.getInstance().onWrenchedPre(ctx, state);
            if (res != InteractionResult.PASS) {
                if (res == InteractionResult.SUCCESS) {
                    this.playWrenchSound(world, pos);
                }
                return res;
            }
            IAirHandler airHandler = (IAirHandler)stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).orElseThrow(RuntimeException::new);
            boolean didWork = false;
            float pressure = airHandler.getPressure();
            IPneumaticWrenchable wrenchable = IPneumaticWrenchable.forBlock(state.m_60734_());
            if (wrenchable != null && pressure > 0.1f) {
                if (wrenchable.onWrenched(world, ctx.m_43723_(), pos, ctx.m_43719_(), hand)) {
                    if (ctx.m_43723_() != null && !ctx.m_43723_().m_7500_()) {
                        airHandler.addAir(-50);
                    }
                    didWork = true;
                }
            } else {
                BlockState rotated = state.rotate((LevelAccessor)world, pos, Rotation.CLOCKWISE_90);
                if (rotated != state) {
                    world.m_46597_(pos, rotated);
                    didWork = true;
                    state = rotated;
                }
            }
            if (didWork) {
                this.playWrenchSound(world, pos);
                ModdedWrenchUtils.getInstance().onWrenchedPost(ctx, state);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    private void playWrenchSound(Level world, BlockPos pos) {
        NetworkHandler.sendToAllTracking(new PacketPlaySound((SoundEvent)ModSounds.PNEUMATIC_WRENCH.get(), SoundSource.PLAYERS, pos, 1.0f, 1.0f, true), world, pos);
    }

    public InteractionResult m_6880_(ItemStack iStack, Player player, LivingEntity target, InteractionHand hand) {
        if (player.f_19853_.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (target.m_6084_() && target instanceof IPneumaticWrenchable) {
            return (InteractionResult)iStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(h -> {
                if (!player.m_7500_() && h.getAir() < 50) {
                    return InteractionResult.FAIL;
                }
                if (((IPneumaticWrenchable)target).onWrenched(target.f_19853_, player, null, null, hand)) {
                    if (!player.m_7500_()) {
                        h.addAir(-50);
                    }
                    this.playWrenchSound(target.f_19853_, target.m_142538_());
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }).orElseThrow(RuntimeException::new);
        }
        return InteractionResult.PASS;
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof ServerPlayer && stack.m_41720_() instanceof IPressurizableItem && ((IPressurizableItem)stack.m_41720_()).getPressure(stack) >= 3.0f) {
            AdvancementTriggers.CHARGED_WRENCH.trigger((ServerPlayer)entityIn);
        }
    }
}

