/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import me.desht.pneumaticcraft.client.gui.MicromissileScreen;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.config.subconfig.MicromissileDefaults;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.entity.projectile.MicromissileEntity;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.RayTraceUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.Validate;

public class MicromissilesItem
extends Item {
    public static final String NBT_TOP_SPEED = "topSpeed";
    public static final String NBT_TURN_SPEED = "turnSpeed";
    public static final String NBT_DAMAGE = "damage";
    public static final String NBT_FILTER = "filter";
    public static final String NBT_PX = "px";
    public static final String NBT_PY = "py";
    public static final String NBT_FIRE_MODE = "fireMode";

    public MicromissilesItem() {
        super(ModItems.defaultProps().m_41487_(1).m_41499_(100));
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)ConfigHelper.common().micromissiles.missilePodSize.get();
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return toRepair.m_41720_() == this && repair.m_41720_() == Blocks.f_50077_.m_5456_();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (playerIn.m_6144_()) {
            if (worldIn.f_46443_) {
                MicromissileScreen.openGui(stack.m_41786_(), handIn);
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        MicromissileEntity missile = new MicromissileEntity(worldIn, (LivingEntity)playerIn, stack);
        Vec3 newPos = missile.m_20182_().m_82549_(playerIn.m_20154_().m_82541_());
        missile.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
        missile.m_37251_((Entity)playerIn, playerIn.m_146909_(), playerIn.m_146908_(), 0.0f, this.getInitialVelocity(stack), 0.0f);
        playerIn.m_36335_().m_41524_((Item)this, ((Integer)ConfigHelper.common().micromissiles.launchCooldown.get()).intValue());
        if (!worldIn.f_46443_) {
            EntityHitResult ertr;
            HitResult res = RayTraceUtils.getMouseOverServer((LivingEntity)playerIn, 100.0);
            if (res instanceof EntityHitResult && missile.isValidTarget((ertr = (EntityHitResult)res).m_82443_())) {
                missile.setTarget(ertr.m_82443_());
            }
            worldIn.m_7967_((Entity)missile);
        }
        if (!playerIn.m_7500_()) {
            stack.m_41622_(1, (LivingEntity)playerIn, playerEntity -> {});
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    private float getInitialVelocity(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag tag = Objects.requireNonNull(stack.m_41783_());
            FireMode fireMode = FireMode.fromString(tag.m_128461_(NBT_FIRE_MODE));
            if (fireMode == FireMode.SMART) {
                return Math.max(0.2f, tag.m_128457_(NBT_TOP_SPEED) / 2.0f);
            }
            return 0.33333334f;
        }
        return 0.33333334f;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> curInfo, TooltipFlag extraInfo) {
        super.m_7373_(stack, worldIn, curInfo, extraInfo);
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.micromissile.remaining", new Object[0]).m_7220_((Component)new TextComponent(Integer.toString(stack.m_41776_() - stack.m_41773_())).m_130940_(ChatFormatting.AQUA)));
        if (stack.m_41782_()) {
            FireMode mode = MicromissilesItem.getFireMode(stack);
            if (mode == FireMode.SMART) {
                CompoundTag tag = Objects.requireNonNull(stack.m_41783_());
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.micromissile.topSpeed", new Object[0]));
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.micromissile.turnSpeed", new Object[0]));
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.micromissile.damage", new Object[0]));
                String filter = tag.m_128461_(NBT_FILTER);
                if (!filter.isEmpty()) {
                    curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.sentryTurret.targetFilter", new Object[0]).m_130946_(": ").m_130946_(ChatFormatting.AQUA + filter));
                }
            }
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.micromissile.firingMode", new Object[0]).m_130946_(": ").m_7220_((Component)PneumaticCraftUtils.xlate(mode.getTranslationKey(), new Object[0]).m_130940_(ChatFormatting.AQUA)));
            if (((Boolean)ConfigHelper.common().micromissiles.damageTerrain.get()).booleanValue()) {
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.terrainWarning", new Object[0]));
            } else {
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.terrainSafe", new Object[0]));
            }
        }
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        MicromissileDefaults.Entry def;
        if (!stack.m_41782_() && entityIn instanceof Player && (def = MicromissileDefaults.INSTANCE.getDefaults((Player)entityIn)) != null) {
            stack.m_41751_(def.toNBT());
        }
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public static void setEntityFilter(ItemStack stack, String filterString) {
        if (stack.m_41720_() instanceof MicromissilesItem) {
            stack.m_41784_().m_128359_(NBT_FILTER, filterString);
        }
    }

    public static FireMode getFireMode(ItemStack stack) {
        Validate.isTrue((boolean)(stack.m_41720_() instanceof MicromissilesItem));
        return stack.m_41782_() ? FireMode.fromString(Objects.requireNonNull(stack.m_41783_()).m_128461_(NBT_FIRE_MODE)) : FireMode.SMART;
    }

    public static enum FireMode implements ITranslatableEnum
    {
        SMART,
        DUMB;


        public static FireMode fromString(String mode) {
            try {
                return FireMode.valueOf(mode);
            }
            catch (IllegalArgumentException e) {
                return SMART;
            }
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.micromissile.mode." + this.toString().toLowerCase(Locale.ROOT);
        }
    }

    public record Tooltip(ItemStack stack) implements TooltipComponent
    {
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent
        public static void onMissilesRepair(AnvilRepairEvent event) {
            if (event.getItemResult().m_41720_() instanceof MicromissilesItem && event.getItemResult().m_41782_()) {
                event.getItemResult().m_41742_(0);
            }
        }
    }
}

